/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.signer;

import java.math.BigInteger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurveKt;
import tech.figure.hdwallet.signer.BTCSignature;
import tech.figure.hdwallet.signer.BigIntegerPair;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Ltech/figure/hdwallet/signer/BTC;", "", "()V", "decode", "Ltech/figure/hdwallet/signer/BigIntegerPair;", "bytes", "", "curveParams", "Ltech/figure/hdwallet/ec/Curve;", "encode", "Ltech/figure/hdwallet/signer/BTCSignature;", "r", "Ljava/math/BigInteger;", "s", "curve", "encode-I-us8xU", "(Ljava/math/BigInteger;Ljava/math/BigInteger;Ltech/figure/hdwallet/ec/Curve;)[B", "signer"})
public final class BTC {
    @NotNull
    public static final BTC INSTANCE = new BTC();

    private BTC() {
    }

    @NotNull
    public final byte[] encode-I-us8xU(@NotNull BigInteger r, @NotNull BigInteger s, @NotNull Curve curve) {
        byte[] sBytes;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        BigInteger halfCurveOrder = curve.getN().shiftRight(1);
        BigInteger sigS = s;
        if (sigS.compareTo(halfCurveOrder) > 0) {
            BigInteger bigInteger = curve.getN().subtract(sigS);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"curve.n.subtract(sigS)");
            sigS = bigInteger;
        }
        if (!((sBytes = BTC.encode_I_us8xU$getUnsignedBytes(sigS)).length <= 32)) {
            boolean $i$a$-require-BTC$encode$32 = false;
            String $i$a$-require-BTC$encode$32 = "cannot encode s into BTC Format, size overflow (" + sBytes.length + " > 32)";
            throw new IllegalArgumentException($i$a$-require-BTC$encode$32.toString());
        }
        byte[] rBytes = BTC.encode_I_us8xU$getUnsignedBytes(r);
        if (!(rBytes.length <= 32)) {
            boolean bl = false;
            String string = "cannot encode r into BTC Format, size overflow (" + rBytes.length + " > 32)";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] signature = new byte[64];
        System.arraycopy(rBytes, 0, signature, 32 - rBytes.length, rBytes.length);
        System.arraycopy(sBytes, 0, signature, 64 - sBytes.length, sBytes.length);
        return BTCSignature.Companion.fromByteArray-2lMcmRk(signature);
    }

    @NotNull
    public final BigIntegerPair decode(@NotNull byte[] bytes, @NotNull Curve curveParams) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)curveParams, (String)"curveParams");
        if (!(bytes.length == 64)) {
            boolean $i$a$-require-BTC$decode$42 = false;
            String $i$a$-require-BTC$decode$42 = "malformed BTC encoded signature, expected 64 bytes";
            throw new IllegalArgumentException($i$a$-require-BTC$decode$42.toString());
        }
        BigInteger halfCurveOrder = curveParams.getN().shiftRight(1);
        BigInteger r = new BigInteger(1, CollectionsKt.toByteArray((Collection)ArraysKt.dropLast((byte[])bytes, (int)32)));
        if (!(r.compareTo(curveParams.getN()) < 0)) {
            boolean bl = false;
            String string = "signature R must be less than curve.N";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger s = new BigInteger(1, CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])bytes, (int)32)));
        if (!(s.compareTo(halfCurveOrder) <= 0)) {
            boolean bl = false;
            String string = "signature S must be less than (curve.N / 2)";
            throw new IllegalArgumentException(string.toString());
        }
        return new BigIntegerPair(r, s);
    }

    public static /* synthetic */ BigIntegerPair decode$default(BTC bTC, byte[] byArray, Curve curve, int n, Object object) {
        if ((n & 2) != 0) {
            curve = CurveKt.getDEFAULT_CURVE();
        }
        return bTC.decode(byArray, curve);
    }

    private static final byte[] encode_I_us8xU$getUnsignedBytes(BigInteger $this$encode_I_us8xU_u24getUnsignedBytes) {
        byte[] bytes = $this$encode_I_us8xU_u24getUnsignedBytes.toByteArray();
        if (bytes[0] == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            return CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])bytes, (int)1));
        }
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return bytes;
    }
}

