/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.signer;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.ec.PrivateKey;
import tech.figure.hdwallet.ec.PublicKey;
import tech.figure.hdwallet.signer.ECDSASignature;
import tech.figure.hdwallet.signer.SignAndVerify;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\b\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Ltech/figure/hdwallet/signer/BCECSigner;", "Ltech/figure/hdwallet/signer/SignAndVerify;", "()V", "sign", "Ltech/figure/hdwallet/signer/ECDSASignature;", "privateKey", "Ltech/figure/hdwallet/ec/PrivateKey;", "payload", "", "signer", "T", "fn", "Lkotlin/Function1;", "Lorg/bouncycastle/crypto/signers/ECDSASigner;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "verify", "", "publicKey", "Ltech/figure/hdwallet/ec/PublicKey;", "data", "signature"})
public class BCECSigner
implements SignAndVerify {
    private final <T> T signer(Function1<? super ECDSASigner, ? extends T> fn) {
        return (T)fn.invoke((Object)new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest())));
    }

    @Override
    @NotNull
    public ECDSASignature sign(@NotNull PrivateKey privateKey, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        ECPrivateKeyParameters params = new ECPrivateKeyParameters(privateKey.getKey(), privateKey.getCurve().getEcDomainParameters());
        BigInteger[] bigIntegerArray = (BigInteger[])this.signer((Function1)new Function1<ECDSASigner, BigInteger[]>(params, payload){
            final /* synthetic */ ECPrivateKeyParameters $params;
            final /* synthetic */ byte[] $payload;
            {
                this.$params = $params;
                this.$payload = $payload;
                super(1);
            }

            public final BigInteger[] invoke(@NotNull ECDSASigner $this$signer) {
                Intrinsics.checkNotNullParameter((Object)$this$signer, (String)"$this$signer");
                $this$signer.init(true, (CipherParameters)this.$params);
                return $this$signer.generateSignature(this.$payload);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bigIntegerArray, (String)"signer {\n            ini\u2026nature(payload)\n        }");
        BigInteger r = bigIntegerArray[0];
        BigInteger s = bigIntegerArray[1];
        Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
        return new ECDSASignature(r, s, null, 4, null);
    }

    @Override
    public boolean verify(@NotNull PublicKey publicKey, @NotNull byte[] data, @NotNull ECDSASignature signature) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        ECPublicKeyParameters params = new ECPublicKeyParameters(publicKey.point().getEcPoint(), publicKey.getCurve().getEcDomainParameters());
        return (Boolean)this.signer((Function1)new Function1<ECDSASigner, Boolean>(params, data, signature){
            final /* synthetic */ ECPublicKeyParameters $params;
            final /* synthetic */ byte[] $data;
            final /* synthetic */ ECDSASignature $signature;
            {
                this.$params = $params;
                this.$data = $data;
                this.$signature = $signature;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ECDSASigner $this$signer) {
                Intrinsics.checkNotNullParameter((Object)$this$signer, (String)"$this$signer");
                $this$signer.init(false, (CipherParameters)this.$params);
                return $this$signer.verifySignature(this.$data, this.$signature.getR(), this.$signature.getS());
            }
        });
    }
}

