/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.signer;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurveKt;
import tech.figure.hdwallet.signer.ASN1;
import tech.figure.hdwallet.signer.BTC;
import tech.figure.hdwallet.signer.BTCSignature;
import tech.figure.hdwallet.signer.BigIntegerPair;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0016\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"Ltech/figure/hdwallet/signer/ECDSASignature;", "", "r", "Ljava/math/BigInteger;", "s", "curve", "Ltech/figure/hdwallet/ec/Curve;", "(Ljava/math/BigInteger;Ljava/math/BigInteger;Ltech/figure/hdwallet/ec/Curve;)V", "getCurve", "()Ltech/figure/hdwallet/ec/Curve;", "halfCurveOrder", "kotlin.jvm.PlatformType", "getR", "()Ljava/math/BigInteger;", "getS", "component1", "component2", "component3", "copy", "encodeAsASN1DER", "Ltech/figure/hdwallet/signer/ASN1Signature;", "encodeAsASN1DER-dag9PwU", "()[B", "encodeAsBTC", "Ltech/figure/hdwallet/signer/BTCSignature;", "encodeAsBTC-5fwCsnE", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "signer"})
public final class ECDSASignature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger r;
    @NotNull
    private final BigInteger s;
    @NotNull
    private final Curve curve;
    private final BigInteger halfCurveOrder;

    public ECDSASignature(@NotNull BigInteger r, @NotNull BigInteger s, @NotNull Curve curve) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        this.r = r;
        this.s = s;
        this.curve = curve;
        this.halfCurveOrder = this.curve.getN().shiftRight(1);
    }

    public /* synthetic */ ECDSASignature(BigInteger bigInteger, BigInteger bigInteger2, Curve curve, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            curve = CurveKt.getDEFAULT_CURVE();
        }
        this(bigInteger, bigInteger2, curve);
    }

    @NotNull
    public final BigInteger getR() {
        return this.r;
    }

    @NotNull
    public final BigInteger getS() {
        return this.s;
    }

    @NotNull
    public final Curve getCurve() {
        return this.curve;
    }

    @NotNull
    public final byte[] encodeAsBTC-5fwCsnE() {
        return BTC.INSTANCE.encode-I-us8xU(this.r, this.s, this.curve);
    }

    @NotNull
    public final byte[] encodeAsASN1DER-dag9PwU() {
        return ASN1.INSTANCE.encode-UA67xwk(this.r, this.s);
    }

    @NotNull
    public final BigInteger component1() {
        return this.r;
    }

    @NotNull
    public final BigInteger component2() {
        return this.s;
    }

    @NotNull
    public final Curve component3() {
        return this.curve;
    }

    @NotNull
    public final ECDSASignature copy(@NotNull BigInteger r, @NotNull BigInteger s, @NotNull Curve curve) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        return new ECDSASignature(r, s, curve);
    }

    public static /* synthetic */ ECDSASignature copy$default(ECDSASignature eCDSASignature, BigInteger bigInteger, BigInteger bigInteger2, Curve curve, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = eCDSASignature.r;
        }
        if ((n & 2) != 0) {
            bigInteger2 = eCDSASignature.s;
        }
        if ((n & 4) != 0) {
            curve = eCDSASignature.curve;
        }
        return eCDSASignature.copy(bigInteger, bigInteger2, curve);
    }

    @NotNull
    public String toString() {
        return "ECDSASignature(r=" + this.r + ", s=" + this.s + ", curve=" + this.curve + ")";
    }

    public int hashCode() {
        int result = this.r.hashCode();
        result = result * 31 + this.s.hashCode();
        result = result * 31 + this.curve.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ECDSASignature)) {
            return false;
        }
        ECDSASignature eCDSASignature = (ECDSASignature)other;
        if (!Intrinsics.areEqual((Object)this.r, (Object)eCDSASignature.r)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.s, (Object)eCDSASignature.s)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.curve, (Object)eCDSASignature.curve);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\n\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\r"}, d2={"Ltech/figure/hdwallet/signer/ECDSASignature$Companion;", "", "()V", "decode", "Ltech/figure/hdwallet/signer/ECDSASignature;", "signature", "Ltech/figure/hdwallet/signer/ASN1Signature;", "curveParams", "Ltech/figure/hdwallet/ec/Curve;", "decode-aBNQp-g", "([BLtech/figure/hdwallet/ec/Curve;)Ltech/figure/hdwallet/signer/ECDSASignature;", "Ltech/figure/hdwallet/signer/BTCSignature;", "decode-elyLmOE", "signer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ECDSASignature decode-elyLmOE(@NotNull byte[] signature, @NotNull Curve curveParams) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)curveParams, (String)"curveParams");
            BigIntegerPair bigIntegerPair = BTC.INSTANCE.decode(BTCSignature.toByteArray-impl(signature), curveParams);
            boolean bl = false;
            boolean bl2 = false;
            BigIntegerPair $this$decode_elyLmOE_u24lambda_u2d0 = bigIntegerPair;
            boolean bl3 = false;
            return new ECDSASignature($this$decode_elyLmOE_u24lambda_u2d0.getR(), $this$decode_elyLmOE_u24lambda_u2d0.getS(), curveParams);
        }

        public static /* synthetic */ ECDSASignature decode-elyLmOE$default(Companion companion, byte[] byArray, Curve curve, int n, Object object) {
            if ((n & 2) != 0) {
                curve = CurveKt.getDEFAULT_CURVE();
            }
            return companion.decode-elyLmOE(byArray, curve);
        }

        @NotNull
        public final ECDSASignature decode-aBNQp-g(@NotNull byte[] signature, @NotNull Curve curveParams) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)curveParams, (String)"curveParams");
            BigIntegerPair bigIntegerPair = ASN1.INSTANCE.decode-uv2mrTw(signature);
            boolean bl = false;
            boolean bl2 = false;
            BigIntegerPair $this$decode_aBNQp_g_u24lambda_u2d1 = bigIntegerPair;
            boolean bl3 = false;
            return new ECDSASignature($this$decode_aBNQp_g_u24lambda_u2d1.getR(), $this$decode_aBNQp_g_u24lambda_u2d1.getS(), curveParams);
        }

        public static /* synthetic */ ECDSASignature decode-aBNQp-g$default(Companion companion, byte[] byArray, Curve curve, int n, Object object) {
            if ((n & 2) != 0) {
                curve = CurveKt.getDEFAULT_CURVE();
            }
            return companion.decode-aBNQp-g(byArray, curve);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

