/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.ec.extensions;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurvePoint;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u0016\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006*\u00020\t\u001a \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\b*\u00020\u000e\u001a\n\u0010\r\u001a\u00020\b*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u00a8\u0006\u0013"}, d2={"asJavaPKCS8ECPrivateKey", "Ljava/security/PrivateKey;", "", "asJavaX509ECPublicKey", "Ljava/security/PublicKey;", "toBigIntegerPair", "Lkotlin/Pair;", "Ljava/math/BigInteger;", "Ltech/figure/hdwallet/ec/Curve;", "Lorg/bouncycastle/jcajce/provider/asymmetric/ec/BCECPrivateKey;", "Lorg/bouncycastle/jcajce/provider/asymmetric/ec/BCECPublicKey;", "compressed", "", "toCurve", "Lorg/bouncycastle/asn1/x9/X9ECParameters;", "Lorg/bouncycastle/jce/spec/ECParameterSpec;", "toCurvePoint", "Ltech/figure/hdwallet/ec/CurvePoint;", "Lorg/bouncycastle/math/ec/ECPoint;", "ec"})
public final class BCKt {
    @NotNull
    public static final Curve toCurve(@NotNull X9ECParameters $this$toCurve) {
        Intrinsics.checkNotNullParameter((Object)$this$toCurve, (String)"<this>");
        BigInteger bigInteger = $this$toCurve.getN();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"n");
        ECPoint eCPoint = $this$toCurve.getG();
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"g");
        CurvePoint curvePoint = BCKt.toCurvePoint(eCPoint);
        ECCurve eCCurve = $this$toCurve.getCurve();
        Intrinsics.checkNotNullExpressionValue((Object)eCCurve, (String)"curve");
        return new Curve(bigInteger, curvePoint, eCCurve);
    }

    @NotNull
    public static final CurvePoint toCurvePoint(@NotNull ECPoint $this$toCurvePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$toCurvePoint, (String)"<this>");
        return new CurvePoint($this$toCurvePoint);
    }

    @NotNull
    public static final Curve toCurve(@NotNull ECParameterSpec $this$toCurve) {
        Intrinsics.checkNotNullParameter((Object)$this$toCurve, (String)"<this>");
        BigInteger bigInteger = $this$toCurve.getN();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"n");
        ECPoint eCPoint = $this$toCurve.getG();
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"g");
        CurvePoint curvePoint = BCKt.toCurvePoint(eCPoint);
        ECCurve eCCurve = $this$toCurve.getCurve();
        Intrinsics.checkNotNullExpressionValue((Object)eCCurve, (String)"curve");
        return new Curve(bigInteger, curvePoint, eCCurve);
    }

    @NotNull
    public static final Pair<BigInteger, Curve> toBigIntegerPair(@NotNull BCECPublicKey $this$toBigIntegerPair, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)$this$toBigIntegerPair, (String)"<this>");
        BigInteger bigInteger = new BigInteger(1, $this$toBigIntegerPair.getQ().getEncoded(compressed));
        ECParameterSpec eCParameterSpec = $this$toBigIntegerPair.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"parameters");
        return new Pair((Object)bigInteger, (Object)BCKt.toCurve(eCParameterSpec));
    }

    public static /* synthetic */ Pair toBigIntegerPair$default(BCECPublicKey bCECPublicKey, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return BCKt.toBigIntegerPair(bCECPublicKey, bl);
    }

    @NotNull
    public static final Pair<BigInteger, Curve> toBigIntegerPair(@NotNull BCECPrivateKey $this$toBigIntegerPair) {
        Intrinsics.checkNotNullParameter((Object)$this$toBigIntegerPair, (String)"<this>");
        BigInteger bigInteger = $this$toBigIntegerPair.getD();
        ECParameterSpec eCParameterSpec = $this$toBigIntegerPair.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"parameters");
        return new Pair((Object)bigInteger, (Object)BCKt.toCurve(eCParameterSpec));
    }

    @NotNull
    public static final PublicKey asJavaX509ECPublicKey(@NotNull byte[] $this$asJavaX509ECPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$asJavaX509ECPublicKey, (String)"<this>");
        PublicKey publicKey = KeyFactory.getInstance("EC", "BC").generatePublic(new X509EncodedKeySpec($this$asJavaX509ECPublicKey));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getInstance(\"EC\", Bouncy\u2026X509EncodedKeySpec(this))");
        return publicKey;
    }

    @NotNull
    public static final PrivateKey asJavaPKCS8ECPrivateKey(@NotNull byte[] $this$asJavaPKCS8ECPrivateKey) {
        Intrinsics.checkNotNullParameter((Object)$this$asJavaPKCS8ECPrivateKey, (String)"<this>");
        PrivateKey privateKey = KeyFactory.getInstance("EC", "BC").generatePrivate(new PKCS8EncodedKeySpec($this$asJavaPKCS8ECPrivateKey));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getInstance(\"EC\", Bouncy\u2026KCS8EncodedKeySpec(this))");
        return privateKey;
    }
}

