/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.ec;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.ECKeyPair;
import tech.figure.hdwallet.ec.PublicKey;
import tech.figure.hdwallet.ec.extensions.BytesKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Ltech/figure/hdwallet/ec/PrivateKey;", "", "key", "Ljava/math/BigInteger;", "curve", "Ltech/figure/hdwallet/ec/Curve;", "(Ljava/math/BigInteger;Ltech/figure/hdwallet/ec/Curve;)V", "getCurve", "()Ltech/figure/hdwallet/ec/Curve;", "getKey", "()Ljava/math/BigInteger;", "toECKeyPair", "Ltech/figure/hdwallet/ec/ECKeyPair;", "toPublicKey", "Ltech/figure/hdwallet/ec/PublicKey;", "Companion", "ec"})
public final class PrivateKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger key;
    @NotNull
    private final Curve curve;

    public PrivateKey(@NotNull BigInteger key, @NotNull Curve curve) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        this.key = key;
        this.curve = curve;
    }

    @NotNull
    public final BigInteger getKey() {
        return this.key;
    }

    @NotNull
    public final Curve getCurve() {
        return this.curve;
    }

    @NotNull
    public final PublicKey toPublicKey() {
        return new PublicKey(this.curve.publicFromPrivate(this.key), this.curve);
    }

    @NotNull
    public final ECKeyPair toECKeyPair() {
        return new ECKeyPair(this, this.toPublicKey());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ltech/figure/hdwallet/ec/PrivateKey$Companion;", "", "()V", "fromBytes", "Ltech/figure/hdwallet/ec/PrivateKey;", "bytes", "", "curve", "Ltech/figure/hdwallet/ec/Curve;", "ec"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivateKey fromBytes(@NotNull byte[] bytes, @NotNull Curve curve) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            return new PrivateKey(BytesKt.packIntoBigInteger(bytes), curve);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

