/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.ec;

import java.math.BigInteger;
import java.security.spec.ECPoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.math.ec.ECCurve;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.ec.extensions.BCKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001c"}, d2={"Ltech/figure/hdwallet/ec/CurvePoint;", "", "ecPoint", "Lorg/bouncycastle/math/ec/ECPoint;", "(Lorg/bouncycastle/math/ec/ECPoint;)V", "getEcPoint", "()Lorg/bouncycastle/math/ec/ECPoint;", "isInfinity", "", "()Z", "x", "Ljava/math/BigInteger;", "getX", "()Ljava/math/BigInteger;", "y", "getY", "add", "n", "encoded", "", "compressed", "mul", "normalize", "toBCECPoint", "curve", "Lorg/bouncycastle/math/ec/ECCurve;", "toJavaECPoint", "Ljava/security/spec/ECPoint;", "ec"})
public final class CurvePoint {
    @NotNull
    private final org.bouncycastle.math.ec.ECPoint ecPoint;
    @NotNull
    private final BigInteger x;
    @NotNull
    private final BigInteger y;
    private final boolean isInfinity;

    public CurvePoint(@NotNull org.bouncycastle.math.ec.ECPoint ecPoint) {
        Intrinsics.checkNotNullParameter((Object)ecPoint, (String)"ecPoint");
        this.ecPoint = ecPoint;
        BigInteger bigInteger = this.ecPoint.getXCoord().toBigInteger();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ecPoint.xCoord.toBigInteger()");
        this.x = bigInteger;
        bigInteger = this.ecPoint.getYCoord().toBigInteger();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ecPoint.yCoord.toBigInteger()");
        this.y = bigInteger;
        this.isInfinity = this.ecPoint.isInfinity();
    }

    @NotNull
    public final org.bouncycastle.math.ec.ECPoint getEcPoint() {
        return this.ecPoint;
    }

    @NotNull
    public final BigInteger getX() {
        return this.x;
    }

    @NotNull
    public final BigInteger getY() {
        return this.y;
    }

    public final boolean isInfinity() {
        return this.isInfinity;
    }

    @NotNull
    public final byte[] encoded(boolean compressed) {
        byte[] byArray = this.ecPoint.getEncoded(compressed);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ecPoint.getEncoded(compressed)");
        return byArray;
    }

    public static /* synthetic */ byte[] encoded$default(CurvePoint curvePoint, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return curvePoint.encoded(bl);
    }

    @NotNull
    public final CurvePoint mul(@NotNull BigInteger n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        org.bouncycastle.math.ec.ECPoint eCPoint = this.ecPoint.multiply(n);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"ecPoint.multiply(n)");
        return BCKt.toCurvePoint(eCPoint);
    }

    @NotNull
    public final CurvePoint add(@NotNull CurvePoint n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        org.bouncycastle.math.ec.ECPoint eCPoint = this.ecPoint.add(n.ecPoint);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"ecPoint.add(n.ecPoint)");
        return BCKt.toCurvePoint(eCPoint);
    }

    @NotNull
    public final CurvePoint normalize() {
        org.bouncycastle.math.ec.ECPoint eCPoint = this.ecPoint.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"ecPoint.normalize()");
        return BCKt.toCurvePoint(eCPoint);
    }

    @NotNull
    public final ECPoint toJavaECPoint() {
        return new ECPoint(this.x, this.y);
    }

    @NotNull
    public final org.bouncycastle.math.ec.ECPoint toBCECPoint(@NotNull ECCurve curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        org.bouncycastle.math.ec.ECPoint eCPoint = EC5Util.convertPoint((ECCurve)curve, (ECPoint)this.toJavaECPoint());
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"convertPoint(curve, toJavaECPoint())");
        return eCPoint;
    }
}

