/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.ec;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurvePoint;
import tech.figure.hdwallet.ec.extensions.BytesKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"PUBLIC_KEY_SIZE", "", "decompressPublicKey", "Ljava/math/BigInteger;", "compressedBytes", "", "curve", "Ltech/figure/hdwallet/ec/Curve;", "legacy", "", "ec"})
public final class CompressionKt {
    public static final int PUBLIC_KEY_SIZE = 64;

    @NotNull
    public static final BigInteger decompressPublicKey(@NotNull byte[] compressedBytes, @NotNull Curve curve, boolean legacy) {
        Intrinsics.checkNotNullParameter((Object)compressedBytes, (String)"compressedBytes");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        CurvePoint point = curve.decodePoint(compressedBytes);
        byte[] x = point.getEcPoint().getXCoord().getEncoded();
        byte[] y = point.getEcPoint().getYCoord().getEncoded();
        ByteBuffer bb = ByteBuffer.allocate(64 + (legacy ? 1 : 0));
        if (legacy) {
            bb.put((byte)4);
        }
        bb.put(x);
        bb.put(y);
        byte[] byArray = bb.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bb.array()");
        return BytesKt.packIntoBigInteger(byArray);
    }

    public static /* synthetic */ BigInteger decompressPublicKey$default(byte[] byArray, Curve curve, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return CompressionKt.decompressPublicKey(byArray, curve, bl);
    }
}

