/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.ec;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.bech32.Bech32DataKt;
import tech.figure.hdwallet.common.hashing.HashKt;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurvePoint;
import tech.figure.hdwallet.ec.extensions.BytesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0017"}, d2={"Ltech/figure/hdwallet/ec/PublicKey;", "", "key", "Ljava/math/BigInteger;", "curve", "Ltech/figure/hdwallet/ec/Curve;", "(Ljava/math/BigInteger;Ltech/figure/hdwallet/ec/Curve;)V", "getCurve", "()Ltech/figure/hdwallet/ec/Curve;", "getKey", "()Ljava/math/BigInteger;", "address", "Ltech/figure/hdwallet/bech32/Address;", "hrp", "", "address-kELETX0", "(Ljava/lang/String;)Ljava/lang/String;", "compressed", "", "point", "Ltech/figure/hdwallet/ec/CurvePoint;", "toString", "Companion", "ec"})
public final class PublicKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger key;
    @NotNull
    private final Curve curve;

    public PublicKey(@NotNull BigInteger key, @NotNull Curve curve) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        this.key = key;
        this.curve = curve;
    }

    @NotNull
    public final BigInteger getKey() {
        return this.key;
    }

    @NotNull
    public final Curve getCurve() {
        return this.curve;
    }

    @NotNull
    public String toString() {
        String string = this.key.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.toString()");
        return string;
    }

    @NotNull
    public final CurvePoint point() {
        byte[] dest = BytesKt.toBytesPadded(this.key, 65);
        dest[0] = 4;
        return this.curve.decodePoint(dest);
    }

    @NotNull
    public final String address-kELETX0(@NotNull String hrp) {
        Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
        return Bech32DataKt.toBech32((byte[])HashKt.sha256hash160((byte[])this.compressed()), (String)hrp).getAddress-5I8iXSs();
    }

    @NotNull
    public final byte[] compressed() {
        return this.point().encoded(true);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ltech/figure/hdwallet/ec/PublicKey$Companion;", "", "()V", "fromBytes", "Ltech/figure/hdwallet/ec/PublicKey;", "bytes", "", "curve", "Ltech/figure/hdwallet/ec/Curve;", "ec"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PublicKey fromBytes(@NotNull byte[] bytes, @NotNull Curve curve) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            return new PublicKey(BytesKt.toBigInteger(bytes), curve);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

