/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.bip39;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.bip39.MnemonicWords;
import tech.figure.hdwallet.bip39.WordListKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\t0\t*\u00020\tH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ltech/figure/hdwallet/bip39/WordList;", "", "dictionary", "", "", "(Ljava/util/List;)V", "createMnemonic", "Ltech/figure/hdwallet/bip39/MnemonicWords;", "entropy", "", "sha256", "kotlin.jvm.PlatformType", "bip39"})
public final class WordList {
    @NotNull
    private final List<char[]> dictionary;

    public WordList(@NotNull List<char[]> dictionary) {
        Intrinsics.checkNotNullParameter(dictionary, (String)"dictionary");
        this.dictionary = dictionary;
    }

    private final byte[] sha256(byte[] $this$sha256) {
        return MessageDigest.getInstance("SHA-256").digest($this$sha256);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MnemonicWords createMnemonic(@NotNull byte[] entropy) {
        Object object;
        int offset;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        int entBits = entropy.length * 8;
        boolean bl = entBits % 32 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Entropy must be multiple of 32";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int checksumLen = entBits / 32;
        byte[] byArray = entropy;
        boolean bl4 = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] checksumEntropy = ArraysKt.plus((byte[])byArray2, (byte)this.sha256(entropy)[0]);
        IntProgression range = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(entBits + checksumLen))), (int)11);
        Iterable iterable = (Iterable)range;
        boolean $i$f$map = false;
        void var9_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl5 = false;
            object = WordListKt.access$next11Bits(checksumEntropy, offset);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void wordIndex;
            offset = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl6 = false;
            object = this.dictionary.get((int)wordIndex);
            collection.add(object);
        }
        List mnemonic2 = (List)destination$iv$iv;
        return new MnemonicWords(mnemonic2);
    }
}

