/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.bip39;

import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.bip39.DeterministicSeed;
import tech.figure.hdwallet.bip39.MnemonicWords;
import tech.figure.hdwallet.bip39.MnemonicWordsKt;
import tech.figure.hdwallet.bip39.WordList;
import tech.figure.hdwallet.bip39.WordlistEnKt;
import tech.figure.hdwallet.common.chararray.CharArrayBuffer;
import tech.figure.hdwallet.common.chararray.CharArraysKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\r\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0011"}, d2={"Ltech/figure/hdwallet/bip39/MnemonicWords;", "", "words", "", "", "(Ljava/util/List;)V", "getWords", "()Ljava/util/List;", "toSeed", "Ltech/figure/hdwallet/bip39/DeterministicSeed;", "passphrase", "toSeed-EO2Dn28", "([C)[B", "normalizeNKFD", "toByteArray", "", "Companion", "bip39"})
public final class MnemonicWords {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<char[]> words;
    public static final int MNEMONIC_ITERATIONS = 2048;
    public static final int KEY_LENGTH = 512;

    public MnemonicWords(@NotNull List<char[]> words) {
        Intrinsics.checkNotNullParameter(words, (String)"words");
        this.words = words;
    }

    @NotNull
    public final List<char[]> getWords() {
        return this.words;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] toByteArray(char[] $this$toByteArray) {
        void $this$mapTo$iv$iv;
        char[] $this$map$iv = $this$toByteArray;
        boolean $i$f$map = false;
        char[] cArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_13 = it;
            boolean bl2 = false;
            Byte by = (byte)(var13_13 & 0xFF);
            collection.add(by);
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }

    private final char[] normalizeNKFD(char[] $this$normalizeNKFD) {
        CharArrayBuffer dest = new CharArrayBuffer();
        int n = 0;
        int n2 = $this$normalizeNKFD.length + -1;
        if (n <= n2) {
            do {
                int index = n++;
                String string = Normalizer.normalize("" + $this$normalizeNKFD[index], Normalizer.Form.NFKD);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(\"\" + this[index], NFKD)");
                dest.append(StringsKt.first((CharSequence)string));
            } while (n <= n2);
        }
        return dest.toCharArray();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] toSeed-EO2Dn28(@NotNull char[] passphrase) {
        String $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Iterable $this$map$iv = this.words;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            char[] cArray = (char[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray2 = this.normalizeNKFD((char[])it);
            collection.add(cArray2);
        }
        char[] mnemonic2 = ((CharArrayBuffer)CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)((Appendable)new CharArrayBuffer()), (CharSequence)" ", null, null, (int)0, null, (Function1)toSeed.mnemonic.2.INSTANCE, (int)60, null)).toCharArray();
        char[] passnorm = this.normalizeNKFD(passphrase);
        $this$mapTo$iv$iv = "mnemonic";
        destination$iv$iv = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = $this$mapTo$iv$iv.getBytes((Charset)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] salt = ArraysKt.plus((byte[])byArray, (byte[])this.toByteArray(passnorm));
        PBEKeySpec spec = new PBEKeySpec(mnemonic2, salt, 2048, 512);
        SecretKeyFactory kf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        SecretKey secretKey = kf.generateSecret(spec);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"kf.generateSecret(spec)");
        return DeterministicSeed.Companion.fromKey-EO2Dn28(secretKey);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ \u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u00042\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltech/figure/hdwallet/bip39/MnemonicWords$Companion;", "", "()V", "KEY_LENGTH", "", "MNEMONIC_ITERATIONS", "fromEntropy", "Ltech/figure/hdwallet/bip39/MnemonicWords;", "entropy", "", "wordList", "", "", "generate", "strength", "of", "words", "", "bip39"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MnemonicWords of(@NotNull String words) {
            Intrinsics.checkNotNullParameter((Object)words, (String)"words");
            String string = words;
            boolean bl = false;
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            return new MnemonicWords(CharArraysKt.split((char[])cArray, (char)' '));
        }

        @NotNull
        public final MnemonicWords generate(int strength, @NotNull List<char[]> wordList) {
            Intrinsics.checkNotNullParameter(wordList, (String)"wordList");
            boolean bl = strength % 32 == 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "strength must be multiple of 32";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.fromEntropy(MnemonicWordsKt.access$randomByteArray(strength / 8), wordList);
        }

        public static /* synthetic */ MnemonicWords generate$default(Companion companion, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 128;
            }
            if ((n2 & 2) != 0) {
                list = WordlistEnKt.getWORDLIST_ENGLISH();
            }
            return companion.generate(n, list);
        }

        @NotNull
        public final MnemonicWords fromEntropy(@NotNull byte[] entropy, @NotNull List<char[]> wordList) {
            Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
            Intrinsics.checkNotNullParameter(wordList, (String)"wordList");
            return new WordList(wordList).createMnemonic(entropy);
        }

        public static /* synthetic */ MnemonicWords fromEntropy$default(Companion companion, byte[] byArray, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = WordlistEnKt.getWORDLIST_ENGLISH();
            }
            return companion.fromEntropy(byArray, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

