/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.bip32;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.bip32.AccountType;
import tech.figure.hdwallet.bip32.ConstantsKt;
import tech.figure.hdwallet.bip32.ExtKey;
import tech.figure.hdwallet.bip32.ExtKeyChainCode;
import tech.figure.hdwallet.bip32.ExtKeyFingerprint;
import tech.figure.hdwallet.bip32.ExtKeyVersion;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurveKt;
import tech.figure.hdwallet.ec.ECKeyPair;
import tech.figure.hdwallet.ec.PrivateKey;
import tech.figure.hdwallet.ec.extensions.BytesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u001a5\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001b"}, d2={"BITCOIN_SEED", "", "CHAINCODE_SIZE", "", "EXTENDED_KEY_SIZE", "HMAC_SHA512", "", "PRIVATE_KEY_SIZE", "hmacSha512", "key", "input", "mkVersionBytes", "Ltech/figure/hdwallet/bip32/ExtKeyVersion;", "publicKeyOnly", "", "testnet", "(ZZ)[B", "getByteArray", "Ljava/nio/ByteBuffer;", "size", "toRootKey", "Ltech/figure/hdwallet/bip32/ExtKey;", "Ltech/figure/hdwallet/bip39/DeterministicSeed;", "curve", "Ltech/figure/hdwallet/ec/Curve;", "toRootKey-wtlqshU", "([BZZLtech/figure/hdwallet/ec/Curve;)Ltech/figure/hdwallet/bip32/ExtKey;", "bip32"})
public final class MasterKeyKt {
    @NotNull
    private static final byte[] BITCOIN_SEED;
    @NotNull
    private static final String HMAC_SHA512 = "HmacSHA512";
    private static final int PRIVATE_KEY_SIZE = 32;
    private static final int CHAINCODE_SIZE = 32;
    private static final int EXTENDED_KEY_SIZE = 78;

    private static final byte[] hmacSha512(byte[] key, byte[] input) {
        Mac mac = Mac.getInstance(HMAC_SHA512);
        boolean bl = false;
        boolean bl2 = false;
        Mac $this$hmacSha512_u24lambda_u2d0 = mac;
        boolean bl3 = false;
        SecretKeySpec spec = new SecretKeySpec(key, HMAC_SHA512);
        $this$hmacSha512_u24lambda_u2d0.init(spec);
        byte[] byArray = $this$hmacSha512_u24lambda_u2d0.doFinal(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(HMAC_SHA512)\u2026     doFinal(input)\n    }");
        return byArray;
    }

    @NotNull
    public static final byte[] getByteArray(@NotNull ByteBuffer $this$getByteArray, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$getByteArray, (String)"<this>");
        byte[] byArray = new byte[size];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        $this$getByteArray.get(it);
        return byArray;
    }

    @NotNull
    public static final ExtKey toRootKey-wtlqshU(@NotNull byte[] $this$toRootKey, boolean publicKeyOnly, boolean testnet, @NotNull Curve curve) {
        ECKeyPair eCKeyPair;
        byte[] i;
        Intrinsics.checkNotNullParameter((Object)$this$toRootKey, (String)"$this$toRootKey");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        byte[] byArray = i = MasterKeyKt.hmacSha512(BITCOIN_SEED, $this$toRootKey);
        int n = 0;
        int n2 = 32;
        int n3 = 0;
        byte[] il = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        byte[] byArray2 = i;
        n2 = 32;
        n3 = 64;
        boolean bl = false;
        byte[] ir = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
        BigInteger ib = BytesKt.packIntoBigInteger((byte[])il);
        if (Intrinsics.areEqual((Object)ib, (Object)BigInteger.ZERO) || ib.compareTo(curve.getN()) >= 0) {
            throw new RuntimeException("Invalid key");
        }
        ECKeyPair eCKeyPair2 = PrivateKey.Companion.fromBytes(il, curve).toECKeyPair();
        bl = false;
        boolean bl2 = false;
        ECKeyPair it = eCKeyPair2;
        boolean bl3 = false;
        if (publicKeyOnly) {
            BigInteger bigInteger = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
            ECKeyPair eCKeyPair3 = new ECKeyPair(new PrivateKey(bigInteger, curve), it.getPublicKey());
            eCKeyPair = eCKeyPair3;
        } else {
            eCKeyPair = it;
        }
        ECKeyPair keyPair = eCKeyPair;
        return new ExtKey(MasterKeyKt.mkVersionBytes(publicKeyOnly, testnet), AccountType.ROOT, ExtKeyFingerprint.constructor-impl$default(null, 1, null), 0, ExtKeyChainCode.constructor-impl(ir), keyPair, null);
    }

    public static /* synthetic */ ExtKey toRootKey-wtlqshU$default(byte[] byArray, boolean bl, boolean bl2, Curve curve, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            curve = CurveKt.getDEFAULT_CURVE();
        }
        return MasterKeyKt.toRootKey-wtlqshU(byArray, bl, bl2, curve);
    }

    private static final byte[] mkVersionBytes(boolean publicKeyOnly, boolean testnet) {
        byte[] ver = publicKeyOnly ? (testnet ? ConstantsKt.getTpub() : ConstantsKt.getXpub()) : (testnet ? ConstantsKt.getTprv() : ConstantsKt.getXprv());
        return ExtKeyVersion.constructor-impl(ver);
    }

    public static final /* synthetic */ byte[] access$hmacSha512(byte[] key, byte[] input) {
        return MasterKeyKt.hmacSha512(key, input);
    }

    static {
        String string = "Bitcoin seed";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        BITCOIN_SEED = byArray;
    }
}

