/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.wallet;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.figure.hdwallet.bip32.ExtKey;
import tech.figure.hdwallet.bip44.PathElement;
import tech.figure.hdwallet.ec.ECKeyPair;
import tech.figure.hdwallet.encoding.base58.Base58Kt;
import tech.figure.hdwallet.signer.BCECSigner;
import tech.figure.hdwallet.signer.BTCSignature;
import tech.figure.hdwallet.signer.Signer;
import tech.figure.hdwallet.wallet.Account;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u0011\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0003H\u0096\u0002J\u0017\u0010\u0012\u001a\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0096\u0002J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0 H\u0016R\u001f\u0010\t\u001a\u00020\nX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Ltech/figure/hdwallet/wallet/DefaultAccount;", "Ltech/figure/hdwallet/wallet/Account;", "hrp", "", "key", "Ltech/figure/hdwallet/bip32/ExtKey;", "signer", "Ltech/figure/hdwallet/signer/Signer;", "(Ljava/lang/String;Ltech/figure/hdwallet/bip32/ExtKey;Ltech/figure/hdwallet/signer/Signer;)V", "address", "Ltech/figure/hdwallet/bech32/Address;", "getAddress-5I8iXSs", "()Ljava/lang/String;", "Ljava/lang/String;", "keyPair", "Ltech/figure/hdwallet/ec/ECKeyPair;", "getKeyPair", "()Ltech/figure/hdwallet/ec/ECKeyPair;", "get", "index", "", "hardened", "", "path", "", "Ltech/figure/hdwallet/bip44/PathElement;", "serializeExtKey", "publicOnly", "sign", "", "payload", "hash", "Lkotlin/Function1;", "hdwallet"})
public final class DefaultAccount
implements Account {
    @NotNull
    private final String hrp;
    @NotNull
    private final ExtKey key;
    @NotNull
    private final Signer signer;
    @NotNull
    private final String address;
    @NotNull
    private final ECKeyPair keyPair;

    public DefaultAccount(@NotNull String hrp, @NotNull ExtKey key, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.hrp = hrp;
        this.key = key;
        this.signer = signer;
        this.address = this.key.getKeyPair().getPublicKey().address-kELETX0(this.hrp);
        this.keyPair = this.key.getKeyPair();
    }

    public /* synthetic */ DefaultAccount(String string, ExtKey extKey, Signer signer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            signer = (Signer)new BCECSigner();
        }
        this(string, extKey, signer);
    }

    @Override
    @NotNull
    public String getAddress-5I8iXSs() {
        return this.address;
    }

    @Override
    @NotNull
    public String serializeExtKey(boolean publicOnly) {
        return Base58Kt.base58EncodeChecked((byte[])this.key.serialize(publicOnly));
    }

    @Override
    @NotNull
    public ECKeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] payload, @NotNull Function1<? super byte[], byte[]> hash) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(hash, (String)"hash");
        return BTCSignature.toByteArray-impl((byte[])this.signer.sign(this.key.getKeyPair().getPrivateKey(), (byte[])hash.invoke((Object)payload)).encodeAsBTC-5fwCsnE());
    }

    @Override
    @NotNull
    public Account get(int index, boolean hardened) {
        return new DefaultAccount(this.hrp, this.key.childKey(index, hardened), this.signer);
    }

    @Override
    @NotNull
    public Account get(@NotNull List<PathElement> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return new DefaultAccount(this.hrp, this.key.childKey(path), null, 4, null);
    }

    @Override
    @NotNull
    public Account get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new DefaultAccount(this.hrp, this.key.childKey(path), null, 4, null);
    }
}

