/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.ec;

import java.math.BigInteger;
import java.security.spec.EllipticCurve;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.hdwallet.ec.CurvePoint;
import tech.figure.hdwallet.ec.extensions.BCKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Ltech/figure/hdwallet/ec/Curve;", "", "n", "Ljava/math/BigInteger;", "g", "Ltech/figure/hdwallet/ec/CurvePoint;", "ecCurve", "Lorg/bouncycastle/math/ec/ECCurve;", "(Ljava/math/BigInteger;Ltech/figure/hdwallet/ec/CurvePoint;Lorg/bouncycastle/math/ec/ECCurve;)V", "ecDomainParameters", "Lorg/bouncycastle/crypto/params/ECDomainParameters;", "getEcDomainParameters", "()Lorg/bouncycastle/crypto/params/ECDomainParameters;", "getG", "()Ltech/figure/hdwallet/ec/CurvePoint;", "getN", "()Ljava/math/BigInteger;", "component1", "component2", "component3", "copy", "createPoint", "x", "y", "decodePoint", "data", "", "equals", "", "other", "fpcMul", "pk", "hashCode", "", "publicFromPrivate", "privateKey", "toBCEllipticCurve", "toJavaEllipticCurve", "Ljava/security/spec/EllipticCurve;", "toString", "", "Companion", "ec"})
public final class Curve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger n;
    @NotNull
    private final CurvePoint g;
    @NotNull
    private final ECCurve ecCurve;
    @NotNull
    private final ECDomainParameters ecDomainParameters;

    public Curve(@NotNull BigInteger n, @NotNull CurvePoint g, @NotNull ECCurve ecCurve) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)ecCurve, (String)"ecCurve");
        this.n = n;
        this.g = g;
        this.ecCurve = ecCurve;
        this.ecDomainParameters = new ECDomainParameters(this.ecCurve, this.g.getEcPoint(), this.n);
    }

    @NotNull
    public final BigInteger getN() {
        return this.n;
    }

    @NotNull
    public final CurvePoint getG() {
        return this.g;
    }

    @NotNull
    public final ECDomainParameters getEcDomainParameters() {
        return this.ecDomainParameters;
    }

    @NotNull
    public final CurvePoint decodePoint(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ECPoint eCPoint = this.ecCurve.decodePoint(data);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"ecCurve.decodePoint(data)");
        return BCKt.toCurvePoint(eCPoint);
    }

    @NotNull
    public final CurvePoint createPoint(@NotNull BigInteger x, @NotNull BigInteger y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        ECPoint eCPoint = this.ecCurve.createPoint(x, y);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"ecCurve.createPoint(x, y)");
        return BCKt.toCurvePoint(eCPoint);
    }

    @NotNull
    public final BigInteger publicFromPrivate(@NotNull BigInteger privateKey) {
        byte[] encoded;
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        CurvePoint point = this.fpcMul(privateKey);
        byte[] byArray = encoded = point.encoded(false);
        int n = 1;
        int n2 = encoded.length;
        return new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
    }

    @NotNull
    public final EllipticCurve toJavaEllipticCurve() {
        EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)this.ecCurve, (byte[])this.ecDomainParameters.getSeed());
        Intrinsics.checkNotNullExpressionValue((Object)ellipticCurve, (String)"convertCurve(ecCurve, ecDomainParameters.seed)");
        return ellipticCurve;
    }

    @NotNull
    public final ECCurve toBCEllipticCurve() {
        ECCurve eCCurve = EC5Util.convertCurve((EllipticCurve)this.toJavaEllipticCurve());
        Intrinsics.checkNotNullExpressionValue((Object)eCCurve, (String)"convertCurve(toJavaEllipticCurve())");
        return eCCurve;
    }

    private final CurvePoint fpcMul(BigInteger pk) {
        BigInteger postProcessedPrivateKey = pk.bitLength() > this.n.bitLength() ? pk.mod(this.n) : pk;
        ECPoint eCPoint = new FixedPointCombMultiplier().multiply(this.g.getEcPoint(), postProcessedPrivateKey);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"FixedPointCombMultiplier\u2026 postProcessedPrivateKey)");
        return BCKt.toCurvePoint(eCPoint);
    }

    @NotNull
    public final BigInteger component1() {
        return this.n;
    }

    @NotNull
    public final CurvePoint component2() {
        return this.g;
    }

    private final ECCurve component3() {
        return this.ecCurve;
    }

    @NotNull
    public final Curve copy(@NotNull BigInteger n, @NotNull CurvePoint g, @NotNull ECCurve ecCurve) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)ecCurve, (String)"ecCurve");
        return new Curve(n, g, ecCurve);
    }

    public static /* synthetic */ Curve copy$default(Curve curve, BigInteger bigInteger, CurvePoint curvePoint, ECCurve eCCurve, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = curve.n;
        }
        if ((n & 2) != 0) {
            curvePoint = curve.g;
        }
        if ((n & 4) != 0) {
            eCCurve = curve.ecCurve;
        }
        return curve.copy(bigInteger, curvePoint, eCCurve);
    }

    @NotNull
    public String toString() {
        return "Curve(n=" + this.n + ", g=" + this.g + ", ecCurve=" + this.ecCurve + ")";
    }

    public int hashCode() {
        int result = this.n.hashCode();
        result = result * 31 + this.g.hashCode();
        result = result * 31 + this.ecCurve.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Curve)) {
            return false;
        }
        Curve curve = (Curve)other;
        if (!Intrinsics.areEqual((Object)this.n, (Object)curve.n)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.g, (Object)curve.g)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.ecCurve, (Object)curve.ecCurve);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/figure/hdwallet/ec/Curve$Companion;", "", "()V", "lookup", "Ltech/figure/hdwallet/ec/Curve;", "name", "", "ec"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Curve lookup(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            X9ECParameters x9ECParameters = CustomNamedCurves.getByName((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)x9ECParameters, (String)"getByName(name)");
            return BCKt.toCurve(x9ECParameters);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

