/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.ec.extensions;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurveKt;
import tech.figure.hdwallet.ec.ECKeyPair;
import tech.figure.hdwallet.ec.PrivateKey;
import tech.figure.hdwallet.ec.PublicKey;
import tech.figure.hdwallet.ec.extensions.BCKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0006\u001a\n\u0010\u000f\u001a\u00020\n*\u00020\t\u001a\n\u0010\u0010\u001a\u00020\u0002*\u00020\f\u001a\n\u0010\u0011\u001a\u00020\u0006*\u00020\u000e\u001a\u0016\u0010\u0012\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0013*\u00020\n\u00a8\u0006\u0015"}, d2={"toBCECPrivateKey", "Lorg/bouncycastle/jcajce/provider/asymmetric/ec/BCECPrivateKey;", "Ljava/security/PrivateKey;", "Ljava/security/interfaces/ECPrivateKey;", "toBCECPublicKey", "Lorg/bouncycastle/jcajce/provider/asymmetric/ec/BCECPublicKey;", "Ljava/security/PublicKey;", "Ljava/security/interfaces/ECPublicKey;", "toECKeyPair", "Ltech/figure/hdwallet/ec/ECKeyPair;", "Ljava/security/KeyPair;", "toECPrivateKey", "Ltech/figure/hdwallet/ec/PrivateKey;", "toECPublicKey", "Ltech/figure/hdwallet/ec/PublicKey;", "toJavaECKeyPair", "toJavaECPrivateKey", "toJavaECPublicKey", "toKeyPair", "Lkotlin/Pair;", "toPair", "ec"})
public final class JavaKeysKt {
    @NotNull
    public static final BCECPublicKey toBCECPublicKey(@NotNull ECPublicKey $this$toBCECPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toBCECPublicKey, (String)"<this>");
        return new BCECPublicKey($this$toBCECPublicKey, BouncyCastlePQCProvider.CONFIGURATION);
    }

    @Nullable
    public static final BCECPublicKey toBCECPublicKey(@NotNull java.security.PublicKey $this$toBCECPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toBCECPublicKey, (String)"<this>");
        return $this$toBCECPublicKey instanceof ECPublicKey ? JavaKeysKt.toBCECPublicKey((ECPublicKey)$this$toBCECPublicKey) : null;
    }

    @NotNull
    public static final PublicKey toECPublicKey(@NotNull java.security.PublicKey $this$toECPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toECPublicKey, (String)"<this>");
        BCECPublicKey bCECPublicKey = JavaKeysKt.toBCECPublicKey($this$toECPublicKey);
        if (bCECPublicKey == null) {
            boolean $i$a$-requireNotNull-JavaKeysKt$toECPublicKey$bcec$22 = false;
            String $i$a$-requireNotNull-JavaKeysKt$toECPublicKey$bcec$22 = "key type invalid: not EC";
            throw new IllegalArgumentException($i$a$-requireNotNull-JavaKeysKt$toECPublicKey$bcec$22.toString());
        }
        BCECPublicKey bcec = bCECPublicKey;
        byte[] q = bcec.getQ().getEncoded(false);
        ECParameterSpec eCParameterSpec = bcec.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"bcec.parameters");
        Curve curve = BCKt.toCurve(eCParameterSpec);
        Intrinsics.checkNotNullExpressionValue((Object)q, (String)"q");
        byte[] byArray = q;
        int n = 1;
        int n2 = q.length;
        BigInteger bytes = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        return new PublicKey(bytes, curve);
    }

    @NotNull
    public static final java.security.PublicKey toJavaECPublicKey(@NotNull PublicKey $this$toJavaECPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaECPublicKey, (String)"<this>");
        java.security.PublicKey publicKey = KeyFactory.getInstance("EC", "BC").generatePublic(new ECPublicKeySpec($this$toJavaECPublicKey.point().toJavaECPoint(), CurveKt.getEcParameterSpec($this$toJavaECPublicKey.getCurve())));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getInstance(\"EC\", Bouncy\u2026, curve.ecParameterSpec))");
        return publicKey;
    }

    @NotNull
    public static final java.security.PrivateKey toJavaECPrivateKey(@NotNull PrivateKey $this$toJavaECPrivateKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaECPrivateKey, (String)"<this>");
        java.security.PrivateKey privateKey = KeyFactory.getInstance("EC", "BC").generatePrivate((KeySpec)new ECPrivateKeySpec($this$toJavaECPrivateKey.getKey(), CurveKt.getBcecParameterSpec($this$toJavaECPrivateKey.getCurve())));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getInstance(\"EC\", Bouncy\u2026curve.bcecParameterSpec))");
        return privateKey;
    }

    @NotNull
    public static final BCECPrivateKey toBCECPrivateKey(@NotNull ECPrivateKey $this$toBCECPrivateKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toBCECPrivateKey, (String)"<this>");
        return new BCECPrivateKey($this$toBCECPrivateKey, BouncyCastlePQCProvider.CONFIGURATION);
    }

    @Nullable
    public static final BCECPrivateKey toBCECPrivateKey(@NotNull java.security.PrivateKey $this$toBCECPrivateKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toBCECPrivateKey, (String)"<this>");
        return $this$toBCECPrivateKey instanceof ECPrivateKey ? JavaKeysKt.toBCECPrivateKey((ECPrivateKey)$this$toBCECPrivateKey) : null;
    }

    @NotNull
    public static final PrivateKey toECPrivateKey(@NotNull java.security.PrivateKey $this$toECPrivateKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toECPrivateKey, (String)"<this>");
        BCECPrivateKey bCECPrivateKey = JavaKeysKt.toBCECPrivateKey($this$toECPrivateKey);
        if (bCECPrivateKey == null) {
            boolean bl = false;
            String string = "key type invalid: not EC";
            throw new IllegalArgumentException(string.toString());
        }
        BCECPrivateKey bcec = bCECPrivateKey;
        BigInteger bigInteger = bcec.getD();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"bcec.d");
        ECParameterSpec eCParameterSpec = bcec.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"bcec.parameters");
        return new PrivateKey(bigInteger, BCKt.toCurve(eCParameterSpec));
    }

    @NotNull
    public static final KeyPair toJavaECKeyPair(@NotNull ECKeyPair $this$toJavaECKeyPair) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaECKeyPair, (String)"<this>");
        return new KeyPair(JavaKeysKt.toJavaECPublicKey($this$toJavaECKeyPair.getPublicKey()), JavaKeysKt.toJavaECPrivateKey($this$toJavaECKeyPair.getPrivateKey()));
    }

    @NotNull
    public static final ECKeyPair toECKeyPair(@NotNull KeyPair $this$toECKeyPair) {
        Intrinsics.checkNotNullParameter((Object)$this$toECKeyPair, (String)"<this>");
        java.security.PrivateKey privateKey = $this$toECKeyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"private");
        PrivateKey privateKey2 = JavaKeysKt.toECPrivateKey(privateKey);
        java.security.PublicKey publicKey = $this$toECKeyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"public");
        return new ECKeyPair(privateKey2, JavaKeysKt.toECPublicKey(publicKey));
    }

    @NotNull
    public static final KeyPair toKeyPair(@NotNull Pair<? extends java.security.PublicKey, ? extends java.security.PrivateKey> $this$toKeyPair) {
        Intrinsics.checkNotNullParameter($this$toKeyPair, (String)"<this>");
        return new KeyPair((java.security.PublicKey)$this$toKeyPair.getFirst(), (java.security.PrivateKey)$this$toKeyPair.getSecond());
    }

    @NotNull
    public static final Pair<java.security.PublicKey, java.security.PrivateKey> toPair(@NotNull KeyPair $this$toPair) {
        Intrinsics.checkNotNullParameter((Object)$this$toPair, (String)"<this>");
        return new Pair((Object)$this$toPair.getPublic(), (Object)$this$toPair.getPrivate());
    }
}

