/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.common.hashing;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\t"}, d2={"hashTwice", "", "offset", "", "len", "hmacSha512", "key", "sha256", "sha256hash160", "common"})
public final class HashKt {
    @NotNull
    public static final byte[] sha256(@NotNull byte[] $this$sha256) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = digest.digest($this$sha256);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n        val digest = M\u2026digest.digest(this)\n    }");
            byArray = byArray2;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Couldn't find a SHA-256 provider", e);
        }
        return byArray;
    }

    @NotNull
    public static final byte[] hashTwice(@NotNull byte[] $this$hashTwice, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)$this$hashTwice, (String)"<this>");
        MessageDigest it = MessageDigest.getInstance("SHA-256");
        boolean bl = false;
        it.update($this$hashTwice, offset, len);
        byte[] byArray = it.digest(it.digest());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"SHA-256\").l\u2026digest(it.digest())\n    }");
        return byArray;
    }

    @NotNull
    public static final byte[] hmacSha512(@NotNull byte[] $this$hmacSha512, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)$this$hmacSha512, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HMac hMac = new HMac((Digest)new SHA512Digest());
        hMac.init((CipherParameters)new KeyParameter(key));
        hMac.update($this$hmacSha512, 0, $this$hmacSha512.length);
        byte[] out = new byte[64];
        hMac.doFinal(out, 0);
        return out;
    }

    @NotNull
    public static final byte[] sha256hash160(@NotNull byte[] $this$sha256hash160) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256hash160, (String)"<this>");
        RIPEMD160Digest digest = new RIPEMD160Digest();
        byte[] sha256 = HashKt.sha256($this$sha256hash160);
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }
}

