/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.eventstream.stream;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.blockchain.stream.api.BlockSink;
import tech.figure.eventstream.stream.ExtensionsKt;
import tech.figure.eventstream.stream.models.BlockHeader;
import tech.figure.eventstream.stream.models.StreamBlock;
import tech.figure.eventstream.stream.models.StreamBlockImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096B\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\t0\t \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\t0\t\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Ltech/figure/eventstream/stream/KafkaBlockSink;", "Ltech/figure/blockchain/stream/api/BlockSink;", "producerProps", "", "", "", "topicName", "kafkaProducer", "Lorg/apache/kafka/clients/producer/Producer;", "", "(Ljava/util/Map;Ljava/lang/String;Lorg/apache/kafka/clients/producer/Producer;)V", "byteArrayProps", "producer", "serializer", "Lorg/apache/kafka/common/serialization/Serializer;", "kotlin.jvm.PlatformType", "invoke", "", "block", "Ltech/figure/eventstream/stream/models/StreamBlock;", "(Ltech/figure/eventstream/stream/models/StreamBlock;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "es-kafka"})
public final class KafkaBlockSink
implements BlockSink {
    @NotNull
    private final String topicName;
    private final Serializer<byte[]> serializer;
    @NotNull
    private final Map<String, Object> byteArrayProps;
    @NotNull
    private final Producer<byte[], byte[]> producer;

    public KafkaBlockSink(@NotNull Map<String, ? extends Object> producerProps, @NotNull String topicName, @Nullable Producer<byte[], byte[]> kafkaProducer) {
        Intrinsics.checkNotNullParameter(producerProps, (String)"producerProps");
        Intrinsics.checkNotNullParameter((Object)topicName, (String)"topicName");
        this.topicName = topicName;
        this.serializer = Serdes.ByteArray().serializer();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key.serializer", this.serializer.getClass()), TuplesKt.to((Object)"value.serializer", this.serializer.getClass())};
        this.byteArrayProps = MapsKt.mapOf((Pair[])pairArray);
        Producer producer = kafkaProducer;
        if (producer == null) {
            producer = (Producer)new KafkaProducer(MapsKt.plus(producerProps, this.byteArrayProps));
        }
        this.producer = producer;
    }

    public /* synthetic */ KafkaBlockSink(Map map2, String string, Producer producer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            producer = null;
        }
        this(map2, string, (Producer<byte[], byte[]>)producer);
    }

    @Nullable
    public Object invoke(@NotNull StreamBlock block2, @NotNull Continuation<? super Unit> $completion) {
        String key;
        BlockHeader blockHeader = block2.getBlock().getHeader();
        Intrinsics.checkNotNull((Object)blockHeader);
        String string = key = blockHeader.getChainId() + "." + block2.getHeight();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Intrinsics.checkNotNull((Object)block2, (String)"null cannot be cast to non-null type tech.figure.eventstream.stream.models.StreamBlockImpl");
        byte[] byArray2 = ExtensionsKt.toByteArray((StreamBlockImpl)block2);
        Intrinsics.checkNotNull((Object)byArray2);
        ProducerRecord record = new ProducerRecord(this.topicName, (Object)byArray, (Object)byArray2);
        this.producer.send(record);
        return Unit.INSTANCE;
    }
}

