/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package tech.figure.eventstream.stream.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import tech.figure.eventstream.stream.models.BroadcastTxCommitResponse
import tech.figure.eventstream.stream.models.BroadcastTxResponse
import tech.figure.eventstream.stream.models.CheckTxResponse
import tech.figure.eventstream.stream.models.ErrorResponse

import com.squareup.moshi.Json

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import tech.figure.eventstream.stream.infrastructure.ApiClient
import tech.figure.eventstream.stream.infrastructure.ApiResponse
import tech.figure.eventstream.stream.infrastructure.ClientException
import tech.figure.eventstream.stream.infrastructure.ClientError
import tech.figure.eventstream.stream.infrastructure.ServerException
import tech.figure.eventstream.stream.infrastructure.ServerError
import tech.figure.eventstream.stream.infrastructure.MultiValueMap
import tech.figure.eventstream.stream.infrastructure.PartConfig
import tech.figure.eventstream.stream.infrastructure.RequestConfig
import tech.figure.eventstream.stream.infrastructure.RequestMethod
import tech.figure.eventstream.stream.infrastructure.ResponseType
import tech.figure.eventstream.stream.infrastructure.Success
import tech.figure.eventstream.stream.infrastructure.toMultiValue

class TxApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://rpc.cosmos.network")
        }
    }

    /**
     * Returns right away, with no response. Does not wait for CheckTx nor DeliverTx results.
     * If you want to be sure that the transaction is included in a block, you can subscribe for the result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html If you haven&#39;t received anything after a couple of blocks, resend it. If the same happens again, send it to some other node. A few reasons why it could happen:  1. malicious node can drop or pretend it had committed your tx 2. malicious proposer (not necessary the one you&#39;re communicating with) can drop transactions, which might become valid in the future (https://github.com/tendermint/tendermint/issues/3322) 3. node can be offline  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return BroadcastTxResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastTxAsync(tx: kotlin.String) : BroadcastTxResponse = withContext(Dispatchers.IO) {
        val localVarResponse = broadcastTxAsyncWithHttpInfo(tx = tx)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastTxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Returns right away, with no response. Does not wait for CheckTx nor DeliverTx results.
     * If you want to be sure that the transaction is included in a block, you can subscribe for the result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html If you haven&#39;t received anything after a couple of blocks, resend it. If the same happens again, send it to some other node. A few reasons why it could happen:  1. malicious node can drop or pretend it had committed your tx 2. malicious proposer (not necessary the one you&#39;re communicating with) can drop transactions, which might become valid in the future (https://github.com/tendermint/tendermint/issues/3322) 3. node can be offline  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return ApiResponse<BroadcastTxResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun broadcastTxAsyncWithHttpInfo(tx: kotlin.String) : ApiResponse<BroadcastTxResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastTxAsyncRequestConfig(tx = tx)

        return@withContext request<Unit, BroadcastTxResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation broadcastTxAsync
     *
     * @param tx The transaction
     * @return RequestConfig
     */
    fun broadcastTxAsyncRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_tx_async",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Returns with the responses from CheckTx and DeliverTx.
     * IMPORTANT: use only for testing and development. In production, use BroadcastTxSync or BroadcastTxAsync. You can subscribe for the transaction result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html  CONTRACT: only returns error if mempool.CheckTx() errs or if we timeout waiting for tx to commit.  If CheckTx or DeliverTx fail, no error will be returned, but the returned result will contain a non-OK ABCI code.  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return BroadcastTxCommitResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastTxCommit(tx: kotlin.String) : BroadcastTxCommitResponse = withContext(Dispatchers.IO) {
        val localVarResponse = broadcastTxCommitWithHttpInfo(tx = tx)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastTxCommitResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Returns with the responses from CheckTx and DeliverTx.
     * IMPORTANT: use only for testing and development. In production, use BroadcastTxSync or BroadcastTxAsync. You can subscribe for the transaction result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html  CONTRACT: only returns error if mempool.CheckTx() errs or if we timeout waiting for tx to commit.  If CheckTx or DeliverTx fail, no error will be returned, but the returned result will contain a non-OK ABCI code.  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return ApiResponse<BroadcastTxCommitResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun broadcastTxCommitWithHttpInfo(tx: kotlin.String) : ApiResponse<BroadcastTxCommitResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastTxCommitRequestConfig(tx = tx)

        return@withContext request<Unit, BroadcastTxCommitResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation broadcastTxCommit
     *
     * @param tx The transaction
     * @return RequestConfig
     */
    fun broadcastTxCommitRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_tx_commit",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Returns with the response from CheckTx. Does not wait for DeliverTx result.
     * If you want to be sure that the transaction is included in a block, you can subscribe for the result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html If you haven&#39;t received anything after a couple of blocks, resend it. If the same happens again, send it to some other node. A few reasons why it could happen:  1. malicious node can drop or pretend it had committed your tx 2. malicious proposer (not necessary the one you&#39;re communicating with) can drop transactions, which might become valid in the future (https://github.com/tendermint/tendermint/issues/3322)   Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return BroadcastTxResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastTxSync(tx: kotlin.String) : BroadcastTxResponse = withContext(Dispatchers.IO) {
        val localVarResponse = broadcastTxSyncWithHttpInfo(tx = tx)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastTxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Returns with the response from CheckTx. Does not wait for DeliverTx result.
     * If you want to be sure that the transaction is included in a block, you can subscribe for the result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html If you haven&#39;t received anything after a couple of blocks, resend it. If the same happens again, send it to some other node. A few reasons why it could happen:  1. malicious node can drop or pretend it had committed your tx 2. malicious proposer (not necessary the one you&#39;re communicating with) can drop transactions, which might become valid in the future (https://github.com/tendermint/tendermint/issues/3322)   Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return ApiResponse<BroadcastTxResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun broadcastTxSyncWithHttpInfo(tx: kotlin.String) : ApiResponse<BroadcastTxResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastTxSyncRequestConfig(tx = tx)

        return@withContext request<Unit, BroadcastTxResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation broadcastTxSync
     *
     * @param tx The transaction
     * @return RequestConfig
     */
    fun broadcastTxSyncRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_tx_sync",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Checks the transaction without executing it.
     * The transaction won&#39;t be added to the mempool.  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return CheckTxResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun checkTx(tx: kotlin.String) : CheckTxResponse = withContext(Dispatchers.IO) {
        val localVarResponse = checkTxWithHttpInfo(tx = tx)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CheckTxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Checks the transaction without executing it.
     * The transaction won&#39;t be added to the mempool.  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
     * @param tx The transaction
     * @return ApiResponse<CheckTxResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun checkTxWithHttpInfo(tx: kotlin.String) : ApiResponse<CheckTxResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = checkTxRequestConfig(tx = tx)

        return@withContext request<Unit, CheckTxResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation checkTx
     *
     * @param tx The transaction
     * @return RequestConfig
     */
    fun checkTxRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/check_tx",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
