/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package tech.figure.eventstream.stream.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import tech.figure.eventstream.stream.models.BlockResponse
import tech.figure.eventstream.stream.models.BlockResultsResponse
import tech.figure.eventstream.stream.models.BlockSearchResponse
import tech.figure.eventstream.stream.models.BlockchainResponse
import tech.figure.eventstream.stream.models.BroadcastEvidenceResponse
import tech.figure.eventstream.stream.models.CommitResponse
import tech.figure.eventstream.stream.models.ConsensusParamsResponse
import tech.figure.eventstream.stream.models.ConsensusStateResponse
import tech.figure.eventstream.stream.models.DumpConsensusResponse
import tech.figure.eventstream.stream.models.EmptyResponse
import tech.figure.eventstream.stream.models.ErrorResponse
import tech.figure.eventstream.stream.models.GenesisResponse
import tech.figure.eventstream.stream.models.NetInfoResponse
import tech.figure.eventstream.stream.models.NumUnconfirmedTransactionsResponse
import tech.figure.eventstream.stream.models.StatusResponse
import tech.figure.eventstream.stream.models.TxResponse
import tech.figure.eventstream.stream.models.TxSearchResponse
import tech.figure.eventstream.stream.models.UnconfirmedTransactionsResponse
import tech.figure.eventstream.stream.models.ValidatorsResponse

import com.squareup.moshi.Json

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import tech.figure.eventstream.stream.infrastructure.ApiClient
import tech.figure.eventstream.stream.infrastructure.ApiResponse
import tech.figure.eventstream.stream.infrastructure.ClientException
import tech.figure.eventstream.stream.infrastructure.ClientError
import tech.figure.eventstream.stream.infrastructure.ServerException
import tech.figure.eventstream.stream.infrastructure.ServerError
import tech.figure.eventstream.stream.infrastructure.MultiValueMap
import tech.figure.eventstream.stream.infrastructure.PartConfig
import tech.figure.eventstream.stream.infrastructure.RequestConfig
import tech.figure.eventstream.stream.infrastructure.RequestMethod
import tech.figure.eventstream.stream.infrastructure.ResponseType
import tech.figure.eventstream.stream.infrastructure.Success
import tech.figure.eventstream.stream.infrastructure.toMultiValue

class InfoApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://rpc.cosmos.network")
        }
    }

    /**
     * Get block at a specified height
     * Get Block. 
     * @param height height to return. If no height is provided, it will fetch the latest block. (optional, default to 0L)
     * @return BlockResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun block(height: kotlin.Long? = 0L) : BlockResponse = withContext(Dispatchers.IO) {
        val localVarResponse = blockWithHttpInfo(height = height)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get block at a specified height
     * Get Block. 
     * @param height height to return. If no height is provided, it will fetch the latest block. (optional, default to 0L)
     * @return ApiResponse<BlockResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun blockWithHttpInfo(height: kotlin.Long?) : ApiResponse<BlockResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = blockRequestConfig(height = height)

        return@withContext request<Unit, BlockResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation block
     *
     * @param height height to return. If no height is provided, it will fetch the latest block. (optional, default to 0L)
     * @return RequestConfig
     */
    fun blockRequestConfig(height: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get block by hash
     * Get Block By Hash. 
     * @param hash block hash
     * @return BlockResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockByHash(hash: kotlin.String) : BlockResponse = withContext(Dispatchers.IO) {
        val localVarResponse = blockByHashWithHttpInfo(hash = hash)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get block by hash
     * Get Block By Hash. 
     * @param hash block hash
     * @return ApiResponse<BlockResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun blockByHashWithHttpInfo(hash: kotlin.String) : ApiResponse<BlockResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = blockByHashRequestConfig(hash = hash)

        return@withContext request<Unit, BlockResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation blockByHash
     *
     * @param hash block hash
     * @return RequestConfig
     */
    fun blockByHashRequestConfig(hash: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("hash", listOf(hash.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block_by_hash",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get block results at a specified height
     * Get block_results. 
     * @param height height to return. If no height is provided, it will fetch informations regarding the latest block. (optional, default to 0L)
     * @return BlockResultsResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockResults(height: kotlin.Long? = 0L) : BlockResultsResponse = withContext(Dispatchers.IO) {
        val localVarResponse = blockResultsWithHttpInfo(height = height)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockResultsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get block results at a specified height
     * Get block_results. 
     * @param height height to return. If no height is provided, it will fetch informations regarding the latest block. (optional, default to 0L)
     * @return ApiResponse<BlockResultsResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun blockResultsWithHttpInfo(height: kotlin.Long?) : ApiResponse<BlockResultsResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = blockResultsRequestConfig(height = height)

        return@withContext request<Unit, BlockResultsResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation blockResults
     *
     * @param height height to return. If no height is provided, it will fetch informations regarding the latest block. (optional, default to 0L)
     * @return RequestConfig
     */
    fun blockResultsRequestConfig(height: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block_results",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Search for blocks by BeginBlock and EndBlock events
     * Search for blocks by BeginBlock and EndBlock events.  See /subscribe for the query syntax. 
     * @param query Query
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @param orderBy Order in which blocks are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height. If empty, default sorting will be still applied. (optional, default to "desc")
     * @return BlockSearchResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockSearch(query: kotlin.String, page: kotlin.Int? = 1, perPage: kotlin.Int? = 30, orderBy: kotlin.String? = "desc") : BlockSearchResponse = withContext(Dispatchers.IO) {
        val localVarResponse = blockSearchWithHttpInfo(query = query, page = page, perPage = perPage, orderBy = orderBy)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockSearchResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Search for blocks by BeginBlock and EndBlock events
     * Search for blocks by BeginBlock and EndBlock events.  See /subscribe for the query syntax. 
     * @param query Query
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @param orderBy Order in which blocks are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height. If empty, default sorting will be still applied. (optional, default to "desc")
     * @return ApiResponse<BlockSearchResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun blockSearchWithHttpInfo(query: kotlin.String, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : ApiResponse<BlockSearchResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = blockSearchRequestConfig(query = query, page = page, perPage = perPage, orderBy = orderBy)

        return@withContext request<Unit, BlockSearchResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation blockSearch
     *
     * @param query Query
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @param orderBy Order in which blocks are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height. If empty, default sorting will be still applied. (optional, default to "desc")
     * @return RequestConfig
     */
    fun blockSearchRequestConfig(query: kotlin.String, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
                if (orderBy != null) {
                    put("order_by", listOf(orderBy.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block_search",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get block headers (max: 20) for minHeight &lt;&#x3D; height &lt;&#x3D; maxHeight.
     * Get block headers for minHeight &lt;&#x3D; height maxHeight.  At most 20 items will be returned. 
     * @param minHeight Minimum block height to return (optional)
     * @param maxHeight Maximum block height to return (optional)
     * @return BlockchainResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockchain(minHeight: kotlin.Long? = null, maxHeight: kotlin.Long? = null) : BlockchainResponse = withContext(Dispatchers.IO) {
        val localVarResponse = blockchainWithHttpInfo(minHeight = minHeight, maxHeight = maxHeight)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockchainResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get block headers (max: 20) for minHeight &lt;&#x3D; height &lt;&#x3D; maxHeight.
     * Get block headers for minHeight &lt;&#x3D; height maxHeight.  At most 20 items will be returned. 
     * @param minHeight Minimum block height to return (optional)
     * @param maxHeight Maximum block height to return (optional)
     * @return ApiResponse<BlockchainResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun blockchainWithHttpInfo(minHeight: kotlin.Long?, maxHeight: kotlin.Long?) : ApiResponse<BlockchainResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = blockchainRequestConfig(minHeight = minHeight, maxHeight = maxHeight)

        return@withContext request<Unit, BlockchainResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation blockchain
     *
     * @param minHeight Minimum block height to return (optional)
     * @param maxHeight Maximum block height to return (optional)
     * @return RequestConfig
     */
    fun blockchainRequestConfig(minHeight: kotlin.Long?, maxHeight: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (minHeight != null) {
                    put("minHeight", listOf(minHeight.toString()))
                }
                if (maxHeight != null) {
                    put("maxHeight", listOf(maxHeight.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/blockchain",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Broadcast evidence of the misbehavior.
     * Broadcast evidence of the misbehavior. 
     * @param evidence JSON evidence
     * @return BroadcastEvidenceResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastEvidence(evidence: kotlin.String) : BroadcastEvidenceResponse = withContext(Dispatchers.IO) {
        val localVarResponse = broadcastEvidenceWithHttpInfo(evidence = evidence)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastEvidenceResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Broadcast evidence of the misbehavior.
     * Broadcast evidence of the misbehavior. 
     * @param evidence JSON evidence
     * @return ApiResponse<BroadcastEvidenceResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun broadcastEvidenceWithHttpInfo(evidence: kotlin.String) : ApiResponse<BroadcastEvidenceResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastEvidenceRequestConfig(evidence = evidence)

        return@withContext request<Unit, BroadcastEvidenceResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation broadcastEvidence
     *
     * @param evidence JSON evidence
     * @return RequestConfig
     */
    fun broadcastEvidenceRequestConfig(evidence: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("evidence", listOf(evidence.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_evidence",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get commit results at a specified height
     * Get Commit. 
     * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
     * @return CommitResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun commit(height: kotlin.Int? = 0) : CommitResponse = withContext(Dispatchers.IO) {
        val localVarResponse = commitWithHttpInfo(height = height)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CommitResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get commit results at a specified height
     * Get Commit. 
     * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
     * @return ApiResponse<CommitResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun commitWithHttpInfo(height: kotlin.Int?) : ApiResponse<CommitResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = commitRequestConfig(height = height)

        return@withContext request<Unit, CommitResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation commit
     *
     * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
     * @return RequestConfig
     */
    fun commitRequestConfig(height: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/commit",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get consensus parameters
     * Get consensus parameters. 
     * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
     * @return ConsensusParamsResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun consensusParams(height: kotlin.Int? = 0) : ConsensusParamsResponse = withContext(Dispatchers.IO) {
        val localVarResponse = consensusParamsWithHttpInfo(height = height)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ConsensusParamsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get consensus parameters
     * Get consensus parameters. 
     * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
     * @return ApiResponse<ConsensusParamsResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun consensusParamsWithHttpInfo(height: kotlin.Int?) : ApiResponse<ConsensusParamsResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = consensusParamsRequestConfig(height = height)

        return@withContext request<Unit, ConsensusParamsResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation consensusParams
     *
     * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
     * @return RequestConfig
     */
    fun consensusParamsRequestConfig(height: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/consensus_params",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get consensus state
     * Get consensus state.  Not safe to call from inside the ABCI application during a block execution. 
     * @return ConsensusStateResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun consensusState() : ConsensusStateResponse = withContext(Dispatchers.IO) {
        val localVarResponse = consensusStateWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ConsensusStateResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get consensus state
     * Get consensus state.  Not safe to call from inside the ABCI application during a block execution. 
     * @return ApiResponse<ConsensusStateResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun consensusStateWithHttpInfo() : ApiResponse<ConsensusStateResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = consensusStateRequestConfig()

        return@withContext request<Unit, ConsensusStateResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation consensusState
     *
     * @return RequestConfig
     */
    fun consensusStateRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/consensus_state",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get consensus state
     * Get consensus state.  Not safe to call from inside the ABCI application during a block execution. 
     * @return DumpConsensusResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun dumpConsensusState() : DumpConsensusResponse = withContext(Dispatchers.IO) {
        val localVarResponse = dumpConsensusStateWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as DumpConsensusResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get consensus state
     * Get consensus state.  Not safe to call from inside the ABCI application during a block execution. 
     * @return ApiResponse<DumpConsensusResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun dumpConsensusStateWithHttpInfo() : ApiResponse<DumpConsensusResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = dumpConsensusStateRequestConfig()

        return@withContext request<Unit, DumpConsensusResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation dumpConsensusState
     *
     * @return RequestConfig
     */
    fun dumpConsensusStateRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/dump_consensus_state",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get Genesis
     * Get genesis. 
     * @return GenesisResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun genesis() : GenesisResponse = withContext(Dispatchers.IO) {
        val localVarResponse = genesisWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as GenesisResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Genesis
     * Get genesis. 
     * @return ApiResponse<GenesisResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun genesisWithHttpInfo() : ApiResponse<GenesisResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = genesisRequestConfig()

        return@withContext request<Unit, GenesisResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation genesis
     *
     * @return RequestConfig
     */
    fun genesisRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/genesis",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Node heartbeat
     * Get node health. Returns empty result (200 OK) on success, no response - in case of an error. 
     * @return EmptyResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun health() : EmptyResponse = withContext(Dispatchers.IO) {
        val localVarResponse = healthWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Node heartbeat
     * Get node health. Returns empty result (200 OK) on success, no response - in case of an error. 
     * @return ApiResponse<EmptyResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun healthWithHttpInfo() : ApiResponse<EmptyResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = healthRequestConfig()

        return@withContext request<Unit, EmptyResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation health
     *
     * @return RequestConfig
     */
    fun healthRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/health",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Network informations
     * Get network info. 
     * @return NetInfoResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun netInfo() : NetInfoResponse = withContext(Dispatchers.IO) {
        val localVarResponse = netInfoWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as NetInfoResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Network informations
     * Get network info. 
     * @return ApiResponse<NetInfoResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun netInfoWithHttpInfo() : ApiResponse<NetInfoResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = netInfoRequestConfig()

        return@withContext request<Unit, NetInfoResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation netInfo
     *
     * @return RequestConfig
     */
    fun netInfoRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/net_info",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get data about unconfirmed transactions
     * Get data about unconfirmed transactions 
     * @return NumUnconfirmedTransactionsResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun numUnconfirmedTxs() : NumUnconfirmedTransactionsResponse = withContext(Dispatchers.IO) {
        val localVarResponse = numUnconfirmedTxsWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as NumUnconfirmedTransactionsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get data about unconfirmed transactions
     * Get data about unconfirmed transactions 
     * @return ApiResponse<NumUnconfirmedTransactionsResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun numUnconfirmedTxsWithHttpInfo() : ApiResponse<NumUnconfirmedTransactionsResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = numUnconfirmedTxsRequestConfig()

        return@withContext request<Unit, NumUnconfirmedTransactionsResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation numUnconfirmedTxs
     *
     * @return RequestConfig
     */
    fun numUnconfirmedTxsRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/num_unconfirmed_txs",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Node Status
     * Get Tendermint status including node info, pubkey, latest block hash, app hash, block height and time. 
     * @return StatusResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun status() : StatusResponse = withContext(Dispatchers.IO) {
        val localVarResponse = statusWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Node Status
     * Get Tendermint status including node info, pubkey, latest block hash, app hash, block height and time. 
     * @return ApiResponse<StatusResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun statusWithHttpInfo() : ApiResponse<StatusResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = statusRequestConfig()

        return@withContext request<Unit, StatusResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation status
     *
     * @return RequestConfig
     */
    fun statusRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/status",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get transactions by hash
     * Get a trasasction 
     * @param hash transaction Hash to retrive
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @return TxResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun tx(hash: kotlin.String, prove: kotlin.Boolean? = false) : TxResponse = withContext(Dispatchers.IO) {
        val localVarResponse = txWithHttpInfo(hash = hash, prove = prove)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get transactions by hash
     * Get a trasasction 
     * @param hash transaction Hash to retrive
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @return ApiResponse<TxResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun txWithHttpInfo(hash: kotlin.String, prove: kotlin.Boolean?) : ApiResponse<TxResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = txRequestConfig(hash = hash, prove = prove)

        return@withContext request<Unit, TxResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation tx
     *
     * @param hash transaction Hash to retrive
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @return RequestConfig
     */
    fun txRequestConfig(hash: kotlin.String, prove: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("hash", listOf(hash.toString()))
                if (prove != null) {
                    put("prove", listOf(prove.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/tx",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Search for transactions
     * Search for transactions w/ their results.  See /subscribe for the query syntax. 
     * @param query Query
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @param orderBy Order in which transactions are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height &amp; index. If empty, default sorting will be still applied. (optional, default to "asc")
     * @return TxSearchResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun txSearch(query: kotlin.String, prove: kotlin.Boolean? = false, page: kotlin.Int? = 1, perPage: kotlin.Int? = 30, orderBy: kotlin.String? = "asc") : TxSearchResponse = withContext(Dispatchers.IO) {
        val localVarResponse = txSearchWithHttpInfo(query = query, prove = prove, page = page, perPage = perPage, orderBy = orderBy)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TxSearchResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Search for transactions
     * Search for transactions w/ their results.  See /subscribe for the query syntax. 
     * @param query Query
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @param orderBy Order in which transactions are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height &amp; index. If empty, default sorting will be still applied. (optional, default to "asc")
     * @return ApiResponse<TxSearchResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun txSearchWithHttpInfo(query: kotlin.String, prove: kotlin.Boolean?, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : ApiResponse<TxSearchResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = txSearchRequestConfig(query = query, prove = prove, page = page, perPage = perPage, orderBy = orderBy)

        return@withContext request<Unit, TxSearchResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation txSearch
     *
     * @param query Query
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @param orderBy Order in which transactions are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height &amp; index. If empty, default sorting will be still applied. (optional, default to "asc")
     * @return RequestConfig
     */
    fun txSearchRequestConfig(query: kotlin.String, prove: kotlin.Boolean?, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
                if (prove != null) {
                    put("prove", listOf(prove.toString()))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
                if (orderBy != null) {
                    put("order_by", listOf(orderBy.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/tx_search",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get the list of unconfirmed transactions
     * Get list of unconfirmed transactions 
     * @param limit Maximum number of unconfirmed transactions to return (max 100) (optional, default to 30)
     * @return UnconfirmedTransactionsResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun unconfirmedTxs(limit: kotlin.Int? = 30) : UnconfirmedTransactionsResponse = withContext(Dispatchers.IO) {
        val localVarResponse = unconfirmedTxsWithHttpInfo(limit = limit)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as UnconfirmedTransactionsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get the list of unconfirmed transactions
     * Get list of unconfirmed transactions 
     * @param limit Maximum number of unconfirmed transactions to return (max 100) (optional, default to 30)
     * @return ApiResponse<UnconfirmedTransactionsResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun unconfirmedTxsWithHttpInfo(limit: kotlin.Int?) : ApiResponse<UnconfirmedTransactionsResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = unconfirmedTxsRequestConfig(limit = limit)

        return@withContext request<Unit, UnconfirmedTransactionsResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation unconfirmedTxs
     *
     * @param limit Maximum number of unconfirmed transactions to return (max 100) (optional, default to 30)
     * @return RequestConfig
     */
    fun unconfirmedTxsRequestConfig(limit: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (limit != null) {
                    put("limit", listOf(limit.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/unconfirmed_txs",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get validator set at a specified height
     * Get Validators. Validators are sorted by voting power. 
     * @param height height to return. If no height is provided, it will fetch validator set which corresponds to the latest block. (optional, default to 0)
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @return ValidatorsResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun validators(height: kotlin.Int? = 0, page: kotlin.Int? = 1, perPage: kotlin.Int? = 30) : ValidatorsResponse = withContext(Dispatchers.IO) {
        val localVarResponse = validatorsWithHttpInfo(height = height, page = page, perPage = perPage)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ValidatorsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get validator set at a specified height
     * Get Validators. Validators are sorted by voting power. 
     * @param height height to return. If no height is provided, it will fetch validator set which corresponds to the latest block. (optional, default to 0)
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @return ApiResponse<ValidatorsResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun validatorsWithHttpInfo(height: kotlin.Int?, page: kotlin.Int?, perPage: kotlin.Int?) : ApiResponse<ValidatorsResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = validatorsRequestConfig(height = height, page = page, perPage = perPage)

        return@withContext request<Unit, ValidatorsResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation validators
     *
     * @param height height to return. If no height is provided, it will fetch validator set which corresponds to the latest block. (optional, default to 0)
     * @param page Page number (1-based) (optional, default to 1)
     * @param perPage Number of entries per page (max: 100) (optional, default to 30)
     * @return RequestConfig
     */
    fun validatorsRequestConfig(height: kotlin.Int?, page: kotlin.Int?, perPage: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/validators",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
