/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package tech.figure.eventstream.stream.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import tech.figure.eventstream.stream.models.ABCIInfoResponse
import tech.figure.eventstream.stream.models.ABCIQueryResponse
import tech.figure.eventstream.stream.models.ErrorResponse

import com.squareup.moshi.Json

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import tech.figure.eventstream.stream.infrastructure.ApiClient
import tech.figure.eventstream.stream.infrastructure.ApiResponse
import tech.figure.eventstream.stream.infrastructure.ClientException
import tech.figure.eventstream.stream.infrastructure.ClientError
import tech.figure.eventstream.stream.infrastructure.ServerException
import tech.figure.eventstream.stream.infrastructure.ServerError
import tech.figure.eventstream.stream.infrastructure.MultiValueMap
import tech.figure.eventstream.stream.infrastructure.PartConfig
import tech.figure.eventstream.stream.infrastructure.RequestConfig
import tech.figure.eventstream.stream.infrastructure.RequestMethod
import tech.figure.eventstream.stream.infrastructure.ResponseType
import tech.figure.eventstream.stream.infrastructure.Success
import tech.figure.eventstream.stream.infrastructure.toMultiValue

class ABCIApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://rpc.cosmos.network")
        }
    }

    /**
     * Get some info about the application.
     * Get some info about the application. 
     * @return ABCIInfoResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun abciInfo() : ABCIInfoResponse = withContext(Dispatchers.IO) {
        val localVarResponse = abciInfoWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ABCIInfoResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get some info about the application.
     * Get some info about the application. 
     * @return ApiResponse<ABCIInfoResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun abciInfoWithHttpInfo() : ApiResponse<ABCIInfoResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = abciInfoRequestConfig()

        return@withContext request<Unit, ABCIInfoResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation abciInfo
     *
     * @return RequestConfig
     */
    fun abciInfoRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/abci_info",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Query the application for some information.
     * Query the application for some information. 
     * @param path Path to the data (\&quot;/a/b/c\&quot;)
     * @param `data` Data
     * @param height Height (0 means latest) (optional, default to 0)
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @return ABCIQueryResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun abciQuery(path: kotlin.String, `data`: kotlin.String, height: kotlin.Int? = 0, prove: kotlin.Boolean? = false) : ABCIQueryResponse = withContext(Dispatchers.IO) {
        val localVarResponse = abciQueryWithHttpInfo(path = path, `data` = `data`, height = height, prove = prove)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ABCIQueryResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Query the application for some information.
     * Query the application for some information. 
     * @param path Path to the data (\&quot;/a/b/c\&quot;)
     * @param `data` Data
     * @param height Height (0 means latest) (optional, default to 0)
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @return ApiResponse<ABCIQueryResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun abciQueryWithHttpInfo(path: kotlin.String, `data`: kotlin.String, height: kotlin.Int?, prove: kotlin.Boolean?) : ApiResponse<ABCIQueryResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = abciQueryRequestConfig(path = path, `data` = `data`, height = height, prove = prove)

        return@withContext request<Unit, ABCIQueryResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation abciQuery
     *
     * @param path Path to the data (\&quot;/a/b/c\&quot;)
     * @param `data` Data
     * @param height Height (0 means latest) (optional, default to 0)
     * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
     * @return RequestConfig
     */
    fun abciQueryRequestConfig(path: kotlin.String, `data`: kotlin.String, height: kotlin.Int?, prove: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("path", listOf(path.toString()))
                put("data", listOf(`data`.toString()))
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
                if (prove != null) {
                    put("prove", listOf(prove.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/abci_query",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
