/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.eventstream.stream.models;

import com.google.common.io.BaseEncoding;
import cosmos.base.v1beta1.CoinOuterClass;
import cosmos.tx.v1beta1.TxOuterClass;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.eventstream.stream.models.Block;
import tech.figure.eventstream.stream.models.BlockData;
import tech.figure.eventstream.stream.models.BlockEvent;
import tech.figure.eventstream.stream.models.BlockHeader;
import tech.figure.eventstream.stream.models.BlockResponse;
import tech.figure.eventstream.stream.models.BlockResultsResponse;
import tech.figure.eventstream.stream.models.BlockResultsResponseResult;
import tech.figure.eventstream.stream.models.BlockResultsResponseResultEvents;
import tech.figure.eventstream.stream.models.BlockResultsResponseResultTxsResults;
import tech.figure.eventstream.stream.models.TxData;
import tech.figure.eventstream.stream.models.TxError;
import tech.figure.eventstream.stream.models.TxEvent;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\n\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\r\u001aB\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u0015\u001a\u001c\u0010\u0016\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\n\u0010\u0018\u001a\u00020\r*\u00020\u0001\u001aJ\u0010\u0019\u001a\u00020\u001a*\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\r\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f\u001a0\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u001d0!\u001a;\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004*\u00020#2\u0006\u0010$\u001a\u00020\b2!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001d0!\u001a0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u001d0!\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u001d*\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0010\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\u0004*\u00020\n\u00a8\u0006)"}, d2={"sha256", "", "input", "blockEvents", "", "Ltech/figure/eventstream/stream/models/BlockEvent;", "Ltech/figure/eventstream/stream/models/BlockResultsResponseResult;", "blockDateTime", "Ljava/time/OffsetDateTime;", "dateTime", "Ltech/figure/eventstream/stream/models/Block;", "Ltech/figure/eventstream/stream/models/BlockHeader;", "hash", "", "toBlockError", "Ltech/figure/eventstream/stream/models/TxError;", "Ltech/figure/eventstream/stream/models/BlockResultsResponseResultTxsResults;", "blockHeight", "", "txHash", "fee", "Lkotlin/Pair;", "toBlockEvent", "Ltech/figure/eventstream/stream/models/BlockResultsResponseResultEvents;", "toHexString", "toTxEvent", "Ltech/figure/eventstream/stream/models/TxEvent;", "note", "txData", "Ltech/figure/eventstream/stream/models/TxData;", "index", "", "txErroredEvents", "Lkotlin/Function1;", "txEvents", "Ltech/figure/eventstream/stream/models/BlockResultsResponse;", "blockDate", "Lkotlin/ParameterName;", "name", "Ltech/figure/eventstream/stream/models/BlockResponse;", "txHashes", "es-api-model"})
public final class ExtensionsKt {
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        String string = BaseEncoding.base16().encode($this$toHexString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"base16().encode(this)");
        return string;
    }

    @NotNull
    public static final byte[] sha256(@Nullable byte[] input) {
        byte[] byArray;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = digest.digest(input);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n        val digest = M\u2026igest.digest(input)\n    }");
            byArray = byArray2;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Couldn't find a SHA-256 provider", e);
        }
        return byArray;
    }

    @NotNull
    public static final String hash(@NotNull String $this$hash) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        return ExtensionsKt.toHexString(ExtensionsKt.sha256(BaseEncoding.base64().decode((CharSequence)$this$hash)));
    }

    @Nullable
    public static final TxData txData(@NotNull Block $this$txData, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$txData, (String)"<this>");
        Object object = $this$txData.getData();
        if (object == null || (object = ((BlockData)object).getTxs()) == null || (object = (String)object.get(index)) == null) {
            return null;
        }
        Object tx2 = object;
        TxOuterClass.Tx decodedTxData = TxOuterClass.Tx.parseFrom((byte[])BaseEncoding.base64().decode((CharSequence)tx2));
        TxOuterClass.Fee feeData = decodedTxData.getAuthInfo().getFee();
        List list = feeData.getAmountList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"feeData.amountList");
        Object object2 = (CoinOuterClass.Coin)CollectionsKt.getOrNull((List)list, (int)0);
        Long amount = object2 != null && (object2 = object2.getAmount()) != null ? Long.valueOf(Long.parseLong((String)object2)) : null;
        List list2 = feeData.getAmountList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"feeData.amountList");
        CoinOuterClass.Coin coin = (CoinOuterClass.Coin)CollectionsKt.getOrNull((List)list2, (int)0);
        String denom = coin != null ? coin.getDenom() : null;
        String string = decodedTxData.getBody().getMemo();
        if (string == null) {
            string = "";
        }
        String note = string;
        Object object3 = $this$txData.getData();
        return new TxData(object3 != null && (object3 = ((BlockData)object3).getTxs()) != null && (object3 = (String)object3.get(index)) != null ? ExtensionsKt.hash((String)object3) : null, (Pair<Long, String>)new Pair((Object)amount, (Object)denom), note);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> txHashes(@NotNull Block $this$txHashes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$txHashes, (String)"<this>");
        Object object = $this$txHashes.getData();
        if (object != null && (object = ((BlockData)object).getTxs()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ExtensionsKt.hash((String)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final OffsetDateTime dateTime(@NotNull Block $this$dateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$dateTime, (String)"<this>");
        BlockHeader blockHeader = $this$dateTime.getHeader();
        return blockHeader != null ? ExtensionsKt.dateTime(blockHeader) : null;
    }

    @Nullable
    public static final OffsetDateTime dateTime(@NotNull BlockHeader $this$dateTime) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$dateTime, (String)"<this>");
        Object object2 = $this$dateTime;
        try {
            BlockHeader $this$dateTime_u24lambda_u2d1 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)OffsetDateTime.parse($this$dateTime_u24lambda_u2d1.getTime(), DateTimeFormatter.ISO_DATE_TIME));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (OffsetDateTime)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Nullable
    public static final TxData txHash(@NotNull BlockResponse $this$txHash, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$txHash, (String)"<this>");
        Serializable serializable = $this$txHash.getResult();
        return serializable != null && (serializable = serializable.getBlock()) != null ? ExtensionsKt.txData((Block)serializable, index) : null;
    }

    @NotNull
    public static final List<TxEvent> txEvents(@NotNull BlockResultsResponse $this$txEvents, @NotNull OffsetDateTime blockDate, @NotNull Function1<? super Integer, TxData> txHash) {
        Intrinsics.checkNotNullParameter((Object)$this$txEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)blockDate, (String)"blockDate");
        Intrinsics.checkNotNullParameter(txHash, (String)"txHash");
        return ExtensionsKt.txEvents($this$txEvents.getResult(), blockDate, txHash);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TxEvent> txEvents(@NotNull BlockResultsResponseResult $this$txEvents, @Nullable OffsetDateTime blockDateTime, @NotNull Function1<? super Integer, TxData> txHash) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$txEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter(txHash, (String)"txHash");
        BlockResultsResponseResult $this$txEvents_u24lambda_u2d5 = $this$txEvents;
        boolean bl = false;
        List<BlockResultsResponseResultTxsResults> list2 = $this$txEvents_u24lambda_u2d5.getTxsResults();
        if (list2 != null) {
            Iterable iterable = list2;
            Collection collection = new ArrayList();
            int n = 0;
            for (Object t : iterable) {
                List list3;
                void tx2;
                int n2;
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BlockResultsResponseResultTxsResults blockResultsResponseResultTxsResults = (BlockResultsResponseResultTxsResults)t;
                int index = n2;
                boolean bl2 = false;
                List<BlockResultsResponseResultEvents> list4 = tx2.getEvents();
                if (list4 != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable2 = list4;
                    boolean $i$f$filter22 = false;
                    void var17_19 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        BlockResultsResponseResultEvents it = (BlockResultsResponseResultEvents)element$iv$iv;
                        boolean bl3 = false;
                        String string = tx2.getCode();
                        boolean bl4 = string != null ? Integer.parseInt(string) == 0 : false;
                        if (!bl4) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $i$f$filter22 = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void blockResultResponseEvents;
                        BlockResultsResponseResultEvents bl3 = (BlockResultsResponseResultEvents)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl5 = false;
                        TxData txData = (TxData)txHash.invoke((Object)index);
                        TxData txData2 = (TxData)txHash.invoke((Object)index);
                        TxData txData3 = (TxData)txHash.invoke((Object)index);
                        collection2.add(ExtensionsKt.toTxEvent((BlockResultsResponseResultEvents)blockResultResponseEvents, $this$txEvents_u24lambda_u2d5.getHeight(), blockDateTime, txData != null ? txData.getTxHash() : null, txData2 != null ? txData2.getFee() : null, txData3 != null ? txData3.getNote() : null));
                    }
                    list3 = (List)destination$iv$iv2;
                } else {
                    list3 = CollectionsKt.emptyList();
                }
                CollectionsKt.addAll((Collection)collection, (Iterable)list3);
            }
            list = (List)collection;
        } else {
            list = null;
        }
        List list5 = list;
        if (list == null) {
            list5 = CollectionsKt.emptyList();
        }
        return list5;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BlockEvent> blockEvents(@NotNull BlockResultsResponseResult $this$blockEvents, @Nullable OffsetDateTime blockDateTime) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$blockEvents, (String)"<this>");
        BlockResultsResponseResult $this$blockEvents_u24lambda_u2d7 = $this$blockEvents;
        boolean bl = false;
        List<BlockResultsResponseResultEvents> list2 = $this$blockEvents_u24lambda_u2d7.getBeginBlockEvents();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list3;
                void e;
                BlockResultsResponseResultEvents blockResultsResponseResultEvents = (BlockResultsResponseResultEvents)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                long l = $this$blockEvents_u24lambda_u2d7.getHeight();
                String string = e.getType();
                if (string == null) {
                    string = "";
                }
                if ((list3 = e.getAttributes()) == null) {
                    list3 = CollectionsKt.emptyList();
                }
                collection.add(new BlockEvent(l, blockDateTime, string, list3));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list4 = list;
        if (list == null) {
            list4 = CollectionsKt.emptyList();
        }
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TxError> txErroredEvents(@NotNull BlockResultsResponseResult $this$txErroredEvents, @Nullable OffsetDateTime blockDateTime, @NotNull Function1<? super Integer, TxData> txHash) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$txErroredEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter(txHash, (String)"txHash");
        BlockResultsResponseResult $this$txErroredEvents_u24lambda_u2d9 = $this$txErroredEvents;
        boolean bl = false;
        List<BlockResultsResponseResultTxsResults> list2 = $this$txErroredEvents_u24lambda_u2d9.getTxsResults();
        if (list2 != null) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = list2;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                TxError txError;
                void tx2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BlockResultsResponseResultTxsResults blockResultsResponseResultTxsResults = (BlockResultsResponseResultTxsResults)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = tx2.getCode();
                if (!(string != null ? Integer.parseInt(string) == 0 : false)) {
                    void index;
                    TxData txData = (TxData)txHash.invoke((Object)((int)index));
                    TxData txData2 = (TxData)txHash.invoke((Object)((int)index));
                    txError = ExtensionsKt.toBlockError((BlockResultsResponseResultTxsResults)tx2, $this$txErroredEvents_u24lambda_u2d9.getHeight(), blockDateTime, txData != null ? txData.getTxHash() : null, txData2 != null ? txData2.getFee() : null);
                } else {
                    txError = null;
                }
                collection.add(txError);
            }
            list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        } else {
            list = null;
        }
        List list3 = list;
        if (list == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Nullable
    public static final TxError toBlockError(@NotNull BlockResultsResponseResultTxsResults $this$toBlockError, long blockHeight, @Nullable OffsetDateTime blockDateTime, @Nullable String txHash, @Nullable Pair<Long, String> fee) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toBlockError, (String)"<this>");
        String string2 = $this$toBlockError.getCode();
        long l = string2 != null ? Long.parseLong(string2) : 0L;
        String string3 = $this$toBlockError.getLog();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = txHash) == null) {
            string = "";
        }
        long l2 = (object = fee) != null && (object = (Long)object.getFirst()) != null ? (Long)object : 0L;
        Object object2 = fee;
        if (object2 == null || (object2 = (String)object2.getSecond()) == null) {
            object2 = "";
        }
        return new TxError(blockHeight, blockDateTime, l, string3, string, l2, (String)object2);
    }

    @NotNull
    public static final BlockEvent toBlockEvent(@NotNull BlockResultsResponseResultEvents $this$toBlockEvent, long blockHeight, @Nullable OffsetDateTime blockDateTime) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toBlockEvent, (String)"<this>");
        String string = $this$toBlockEvent.getType();
        if (string == null) {
            string = "";
        }
        if ((list = $this$toBlockEvent.getAttributes()) == null) {
            list = CollectionsKt.emptyList();
        }
        return new BlockEvent(blockHeight, blockDateTime, string, list);
    }

    @NotNull
    public static final TxEvent toTxEvent(@NotNull BlockResultsResponseResultEvents $this$toTxEvent, long blockHeight, @Nullable OffsetDateTime blockDateTime, @Nullable String txHash, @Nullable Pair<Long, String> fee, @Nullable String note) {
        List list;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toTxEvent, (String)"<this>");
        String string2 = txHash;
        if (string2 == null) {
            string2 = "";
        }
        if ((string = $this$toTxEvent.getType()) == null) {
            string = "";
        }
        if ((list = $this$toTxEvent.getAttributes()) == null) {
            list = CollectionsKt.emptyList();
        }
        Pair<Long, String> pair = fee;
        Pair<Long, String> pair2 = fee;
        return new TxEvent(blockHeight, blockDateTime, string2, string, list, pair != null ? (Long)pair.getFirst() : null, pair2 != null ? (String)pair2.getSecond() : null, note);
    }
}

