/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.coroutines.retry;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import tech.figure.coroutines.retry.RetryStrategy;
import tech.figure.coroutines.retry.RetryStrategyKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\t0\u0006\"\u0004\b\u0000\u0010\u0007\"\b\b\u0001\u0010\b*\u00020\nH\u0002\u001a&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\t0\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\bH\u0002\u001a\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\r*\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"defaultRetryStrategies", "", "Ltech/figure/coroutines/retry/RetryStrategy;", "getDefaultRetryStrategies", "()Ljava/util/List;", "logFailure", "Lkotlin/Function2;", "A", "B", "", "", "noop2", "invert", "", "Lkotlin/ranges/IntRange;", "ft-coroutines-retry"})
public final class RetryStrategyKt {
    @NotNull
    private static final List<RetryStrategy> defaultRetryStrategies;

    private static final <A, B> Function2<A, B, Unit> noop2() {
        return noop2.1.INSTANCE;
    }

    private static final <A, B extends Throwable> Function2<A, B, Unit> logFailure() {
        KLogger log2 = KotlinLogging.INSTANCE.logger((Function0)logFailure.log.1.INSTANCE);
        return new Function2<A, B, Unit>(log2){
            final /* synthetic */ KLogger $log;
            {
                this.$log = $log;
                super(2);
            }

            public final void invoke(A it, @NotNull B e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                this.$log.error("failed to process " + it, e);
            }
        };
    }

    @NotNull
    public static final List<RetryStrategy> getDefaultRetryStrategies() {
        return defaultRetryStrategies;
    }

    @NotNull
    public static final Map<IntRange, RetryStrategy> invert(@NotNull List<RetryStrategy> $this$invert) {
        Intrinsics.checkNotNullParameter($this$invert, (String)"<this>");
        int idx = 0;
        Map map = new LinkedHashMap();
        for (RetryStrategy retry : $this$invert) {
            map.putIfAbsent(RangesKt.until((int)idx, (int)(retry.getAttempts() + idx)), retry);
            idx += retry.getAttempts();
        }
        return map;
    }

    public static final /* synthetic */ Function2 access$logFailure() {
        return RetryStrategyKt.logFailure();
    }

    static {
        Object[] objectArray = new RetryStrategy[6];
        objectArray[0] = new RetryStrategy(DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), 3, RetryStrategyKt.noop2(), null);
        objectArray[1] = new RetryStrategy(DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES), 5, null, 4, null);
        objectArray[2] = new RetryStrategy(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS), 5, null, 4, null);
        objectArray[3] = new RetryStrategy(DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.HOURS), 2, null, 4, null);
        objectArray[4] = new RetryStrategy(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS), 8, null, 4, null);
        objectArray[5] = new RetryStrategy(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS), 2147483624, null, 4, null);
        defaultRetryStrategies = CollectionsKt.listOf((Object[])objectArray);
    }
}

