/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.kafka.records;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.kafka.records.KafkaRecord;
import tech.figure.kafka.records.KafkaRecordKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005H\u0000\u001a#\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\t*\u0004\u0018\u0001H\bH\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"wrapping", "Ltech/figure/kafka/records/KafkaRecord;", "K", "V", "consumerRecord", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "toOptional", "Ljava/util/Optional;", "T", "", "(Ljava/lang/Object;)Ljava/util/Optional;", "ft-coroutines-kafka"})
public final class KafkaRecordKt {
    @NotNull
    public static final <K, V> KafkaRecord<K, V> wrapping(@NotNull ConsumerRecord<K, V> consumerRecord) {
        Intrinsics.checkNotNullParameter(consumerRecord, (String)"consumerRecord");
        return new KafkaRecord<K, V>(consumerRecord){
            @NotNull
            private final String topic;
            private final K key;
            private final V value;
            @NotNull
            private final List<Header> headers;
            private final int partition;
            private final long offset;
            private final long timestamp;
            @NotNull
            private final TimestampType timestampType;
            @Nullable
            private final Integer leaderEpoch;
            private final int serializedKeySize;
            private final int serializedValueSize;
            {
                String string = $consumerRecord.topic();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"consumerRecord.topic()");
                this.topic = string;
                this.key = $consumerRecord.key();
                this.value = $consumerRecord.value();
                Headers headers = $consumerRecord.headers();
                Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"consumerRecord.headers()");
                this.headers = CollectionsKt.toList((Iterable)((Iterable)headers));
                this.partition = $consumerRecord.partition();
                this.offset = $consumerRecord.offset();
                this.timestamp = $consumerRecord.timestamp();
                TimestampType timestampType = $consumerRecord.timestampType();
                Intrinsics.checkNotNullExpressionValue((Object)timestampType, (String)"consumerRecord.timestampType()");
                this.timestampType = timestampType;
                this.leaderEpoch = $consumerRecord.leaderEpoch().orElseGet(wrapping.1::leaderEpoch$lambda$0);
                this.serializedKeySize = $consumerRecord.serializedKeySize();
                this.serializedValueSize = $consumerRecord.serializedValueSize();
            }

            @NotNull
            public String getTopic() {
                return this.topic;
            }

            public K getKey() {
                return this.key;
            }

            public V getValue() {
                return this.value;
            }

            @NotNull
            public List<Header> getHeaders() {
                return this.headers;
            }

            public int getPartition() {
                return this.partition;
            }

            public long getOffset() {
                return this.offset;
            }

            public long getTimestamp() {
                return this.timestamp;
            }

            @NotNull
            public TimestampType getTimestampType() {
                return this.timestampType;
            }

            @Nullable
            public Integer getLeaderEpoch() {
                return this.leaderEpoch;
            }

            public int getSerializedKeySize() {
                return this.serializedKeySize;
            }

            public int getSerializedValueSize() {
                return this.serializedValueSize;
            }

            @NotNull
            public ConsumerRecord<K, V> toConsumerRecord() {
                return KafkaRecord.DefaultImpls.toConsumerRecord(this);
            }

            private static final Integer leaderEpoch$lambda$0() {
                return null;
            }
        };
    }

    private static final <T> Optional<T> toOptional(T $this$toOptional) {
        Optional optional;
        if ($this$toOptional == null) {
            Optional optional2 = Optional.empty();
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"{\n        Optional.empty()\n    }");
        } else {
            Optional<T> optional3 = Optional.of($this$toOptional);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"{\n        Optional.of(this)\n    }");
        }
        return optional;
    }

    public static final /* synthetic */ Optional access$toOptional(Object $receiver) {
        return KafkaRecordKt.toOptional($receiver);
    }
}

