/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.kafka.context.extensions;

import java.time.Instant;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.jetbrains.annotations.NotNull;
import tech.figure.kafka.records.KafkaRecord;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\"\u0010\b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n*\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\u000b\u001a\"\u0010\b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n*\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"VALID_TIMESTAMP_TYPES", "", "Lorg/apache/kafka/common/record/TimestampType;", "getKafkaTimestampInstant", "Ljava/time/Instant;", "timestampType", "millis", "", "timestampAsInstant", "K", "V", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "Ltech/figure/kafka/records/KafkaRecord;", "ft-coroutines-kafka"})
public final class ExtensionsKt {
    @NotNull
    private static final Set<TimestampType> VALID_TIMESTAMP_TYPES;

    @NotNull
    public static final <K, V> Instant timestampAsInstant(@NotNull ConsumerRecord<K, V> $this$timestampAsInstant) {
        Intrinsics.checkNotNullParameter($this$timestampAsInstant, (String)"<this>");
        TimestampType timestampType = $this$timestampAsInstant.timestampType();
        Intrinsics.checkNotNullExpressionValue((Object)timestampType, (String)"timestampType()");
        return ExtensionsKt.getKafkaTimestampInstant(timestampType, $this$timestampAsInstant.timestamp());
    }

    @NotNull
    public static final <K, V> Instant timestampAsInstant(@NotNull KafkaRecord<K, V> $this$timestampAsInstant) {
        Intrinsics.checkNotNullParameter($this$timestampAsInstant, (String)"<this>");
        return ExtensionsKt.getKafkaTimestampInstant($this$timestampAsInstant.getTimestampType(), $this$timestampAsInstant.getTimestamp());
    }

    private static final Instant getKafkaTimestampInstant(TimestampType timestampType, long millis) {
        if (!VALID_TIMESTAMP_TYPES.contains(timestampType)) {
            throw new IllegalStateException(("Unexpected timestamp type [" + timestampType + "] with millis [" + millis + "]").toString());
        }
        Instant instant = Instant.ofEpochMilli(millis);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"{\n    Instant.ofEpochMilli(millis)\n}");
        return instant;
    }

    static {
        Object[] objectArray = new TimestampType[]{TimestampType.CREATE_TIME, TimestampType.LOG_APPEND_TIME};
        VALID_TIMESTAMP_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

