/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.kafka.records;

import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.kafka.records.CommitConsumerRecord;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Ltech/figure/kafka/records/CommitConsumerRecordImpl;", "Ltech/figure/kafka/records/CommitConsumerRecord;", "duration", "Ljava/time/Duration;", "topicPartition", "Lorg/apache/kafka/common/TopicPartition;", "offsetAndMetadata", "Lorg/apache/kafka/clients/consumer/OffsetAndMetadata;", "commitAck", "Lkotlinx/coroutines/channels/Channel;", "", "(Ljava/time/Duration;Lorg/apache/kafka/common/TopicPartition;Lorg/apache/kafka/clients/consumer/OffsetAndMetadata;Lkotlinx/coroutines/channels/Channel;)V", "getCommitAck", "()Lkotlinx/coroutines/channels/Channel;", "getDuration", "()Ljava/time/Duration;", "getOffsetAndMetadata", "()Lorg/apache/kafka/clients/consumer/OffsetAndMetadata;", "getTopicPartition", "()Lorg/apache/kafka/common/TopicPartition;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ft-coroutines-kafka"})
public final class CommitConsumerRecordImpl
implements CommitConsumerRecord {
    @NotNull
    private final Duration duration;
    @NotNull
    private final TopicPartition topicPartition;
    @NotNull
    private final OffsetAndMetadata offsetAndMetadata;
    @NotNull
    private final Channel<Unit> commitAck;

    public CommitConsumerRecordImpl(@NotNull Duration duration, @NotNull TopicPartition topicPartition, @NotNull OffsetAndMetadata offsetAndMetadata, @NotNull Channel<Unit> commitAck) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)topicPartition, (String)"topicPartition");
        Intrinsics.checkNotNullParameter((Object)offsetAndMetadata, (String)"offsetAndMetadata");
        Intrinsics.checkNotNullParameter(commitAck, (String)"commitAck");
        this.duration = duration;
        this.topicPartition = topicPartition;
        this.offsetAndMetadata = offsetAndMetadata;
        this.commitAck = commitAck;
    }

    @Override
    @NotNull
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    @NotNull
    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    @Override
    @NotNull
    public OffsetAndMetadata getOffsetAndMetadata() {
        return this.offsetAndMetadata;
    }

    @Override
    @NotNull
    public Channel<Unit> getCommitAck() {
        return this.commitAck;
    }

    @Override
    @NotNull
    public Map<TopicPartition, OffsetAndMetadata> asCommitable() {
        return CommitConsumerRecord.DefaultImpls.asCommitable(this);
    }

    @NotNull
    public final Duration component1() {
        return this.getDuration();
    }

    @NotNull
    public final TopicPartition component2() {
        return this.getTopicPartition();
    }

    @NotNull
    public final OffsetAndMetadata component3() {
        return this.getOffsetAndMetadata();
    }

    @NotNull
    public final Channel<Unit> component4() {
        return this.getCommitAck();
    }

    @NotNull
    public final CommitConsumerRecordImpl copy(@NotNull Duration duration, @NotNull TopicPartition topicPartition, @NotNull OffsetAndMetadata offsetAndMetadata, @NotNull Channel<Unit> commitAck) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)topicPartition, (String)"topicPartition");
        Intrinsics.checkNotNullParameter((Object)offsetAndMetadata, (String)"offsetAndMetadata");
        Intrinsics.checkNotNullParameter(commitAck, (String)"commitAck");
        return new CommitConsumerRecordImpl(duration, topicPartition, offsetAndMetadata, commitAck);
    }

    public static /* synthetic */ CommitConsumerRecordImpl copy$default(CommitConsumerRecordImpl commitConsumerRecordImpl, Duration duration, TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata, Channel channel, int n, Object object) {
        if ((n & 1) != 0) {
            duration = commitConsumerRecordImpl.getDuration();
        }
        if ((n & 2) != 0) {
            topicPartition = commitConsumerRecordImpl.getTopicPartition();
        }
        if ((n & 4) != 0) {
            offsetAndMetadata = commitConsumerRecordImpl.getOffsetAndMetadata();
        }
        if ((n & 8) != 0) {
            channel = commitConsumerRecordImpl.getCommitAck();
        }
        return commitConsumerRecordImpl.copy(duration, topicPartition, offsetAndMetadata, channel);
    }

    @NotNull
    public String toString() {
        return "CommitConsumerRecordImpl(duration=" + this.getDuration() + ", topicPartition=" + this.getTopicPartition() + ", offsetAndMetadata=" + this.getOffsetAndMetadata() + ", commitAck=" + this.getCommitAck() + ")";
    }

    public int hashCode() {
        int result = this.getDuration().hashCode();
        result = result * 31 + this.getTopicPartition().hashCode();
        result = result * 31 + this.getOffsetAndMetadata().hashCode();
        result = result * 31 + this.getCommitAck().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommitConsumerRecordImpl)) {
            return false;
        }
        CommitConsumerRecordImpl commitConsumerRecordImpl = (CommitConsumerRecordImpl)other;
        if (!Intrinsics.areEqual((Object)this.getDuration(), (Object)commitConsumerRecordImpl.getDuration())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTopicPartition(), (Object)commitConsumerRecordImpl.getTopicPartition())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getOffsetAndMetadata(), (Object)commitConsumerRecordImpl.getOffsetAndMetadata())) {
            return false;
        }
        return Intrinsics.areEqual(this.getCommitAck(), commitConsumerRecordImpl.getCommitAck());
    }
}

