/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.classification.asset.verifier.event.defaults;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.classification.asset.client.domain.model.AssetOnboardingStatus;
import tech.figure.classification.asset.util.wallet.ProvenanceAccountDetail;
import tech.figure.classification.asset.verifier.config.VerifierEvent;
import tech.figure.classification.asset.verifier.event.AssetClassificationEventHandler;
import tech.figure.classification.asset.verifier.event.EventHandlerParameters;
import tech.figure.classification.asset.verifier.provenance.ACContractEvent;
import tech.figure.classification.asset.verifier.provenance.AssetClassificationEvent;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Ltech/figure/classification/asset/verifier/event/defaults/DefaultVerifyAssetEventHandler;", "Ltech/figure/classification/asset/verifier/event/AssetClassificationEventHandler;", "()V", "eventType", "Ltech/figure/classification/asset/verifier/provenance/ACContractEvent;", "getEventType", "()Ltech/figure/classification/asset/verifier/provenance/ACContractEvent;", "expectedOnboardingStatuses", "", "Ltech/figure/classification/asset/client/domain/model/AssetOnboardingStatus;", "handleEvent", "", "parameters", "Ltech/figure/classification/asset/verifier/event/EventHandlerParameters;", "(Ltech/figure/classification/asset/verifier/event/EventHandlerParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifier"})
public final class DefaultVerifyAssetEventHandler
implements AssetClassificationEventHandler {
    @NotNull
    public static final DefaultVerifyAssetEventHandler INSTANCE = new DefaultVerifyAssetEventHandler();
    @NotNull
    private static final List<AssetOnboardingStatus> expectedOnboardingStatuses;
    @NotNull
    private static final ACContractEvent eventType;

    private DefaultVerifyAssetEventHandler() {
    }

    @Override
    @NotNull
    public ACContractEvent getEventType() {
        return eventType;
    }

    @Override
    @Nullable
    public Object handleEvent(@NotNull EventHandlerParameters parameters, @NotNull Continuation<? super Unit> $completion) {
        AssetOnboardingStatus assetOnboardingStatus2;
        Channel<VerifierEvent> eventChannel;
        AssetClassificationEvent event;
        block14: {
            String messagePrefix;
            block13: {
                AssetOnboardingStatus assetOnboardingStatus3;
                event = parameters.component1();
                ProvenanceAccountDetail verifierAccount = parameters.component3();
                eventChannel = parameters.component6();
                messagePrefix = "[VERIFY ASSET | Tx: " + event.getSourceEvent().getTxHash() + " | Asset " + event.getScopeAddress() + " / " + event.getAssetType();
                if (event.getVerifierAddress() == null) {
                    Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredNoVerifierAddress(event, this.getEventType(), null, 4, null), $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
                if (!Intrinsics.areEqual((Object)event.getVerifierAddress(), (Object)parameters.getVerifierAccount().getBech32Address())) {
                    Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredDifferentVerifierAddress(event, this.getEventType(), verifierAccount.getBech32Address(), null, 8, null), $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
                if (event.getScopeAddress() == null) {
                    DefaultVerifyAssetEventHandler $this$handleEvent_u24lambda_u2d0 = this;
                    boolean bl = false;
                    Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredMissingScopeAddress(event, $this$handleEvent_u24lambda_u2d0.getEventType(), messagePrefix + " Expected the verify asset event to include a scope address, but it was missing"), $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
                if (event.getAssetType() == null) {
                    DefaultVerifyAssetEventHandler $this$handleEvent_u24lambda_u2d1 = this;
                    boolean bl = false;
                    Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredMissingAssetType(event, $this$handleEvent_u24lambda_u2d1.getEventType(), messagePrefix + " Expected the verify asset event to include an asset type, but it was missing"), $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
                AssetOnboardingStatus assetOnboardingStatus4 = event.getAssetOnboardingStatus();
                if (assetOnboardingStatus4 == null) break block13;
                AssetOnboardingStatus it = assetOnboardingStatus3 = assetOnboardingStatus4;
                boolean bl = false;
                Object object = assetOnboardingStatus2 = expectedOnboardingStatuses.contains(it) ? assetOnboardingStatus3 : null;
                if (assetOnboardingStatus2 != null) break block14;
            }
            DefaultVerifyAssetEventHandler $this$handleEvent_u24lambda_u2d3 = this;
            boolean bl = false;
            AssetOnboardingStatus assetOnboardingStatus5 = event.getAssetOnboardingStatus();
            Object object = eventChannel.send((Object)new VerifierEvent.VerifyEventUnexpectedOnboardingStatus(event, messagePrefix + " Verification produced an unexpected onboarding status of [" + (assetOnboardingStatus5 != null ? assetOnboardingStatus5.getContractName() : null) + "]"), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        AssetOnboardingStatus onboardingStatus = assetOnboardingStatus2;
        Object object = eventChannel.send((Object)new VerifierEvent.VerifyEventSuccessful(event, onboardingStatus), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new AssetOnboardingStatus[]{AssetOnboardingStatus.APPROVED, AssetOnboardingStatus.DENIED};
        expectedOnboardingStatuses = CollectionsKt.listOf((Object[])objectArray);
        eventType = ACContractEvent.VERIFY_ASSET;
    }
}

