/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.classification.asset.verifier.event.defaults;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.classification.asset.client.client.base.ACClient;
import tech.figure.classification.asset.client.domain.model.AssetOnboardingStatus;
import tech.figure.classification.asset.client.domain.model.AssetScopeAttribute;
import tech.figure.classification.asset.util.wallet.ProvenanceAccountDetail;
import tech.figure.classification.asset.verifier.config.VerifierEvent;
import tech.figure.classification.asset.verifier.event.AssetClassificationEventHandler;
import tech.figure.classification.asset.verifier.event.EventHandlerParameters;
import tech.figure.classification.asset.verifier.provenance.ACContractEvent;
import tech.figure.classification.asset.verifier.provenance.AssetClassificationEvent;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"Ltech/figure/classification/asset/verifier/event/defaults/DefaultVerifyAssetEventHandler;", "Ltech/figure/classification/asset/verifier/event/AssetClassificationEventHandler;", "()V", "eventType", "Ltech/figure/classification/asset/verifier/provenance/ACContractEvent;", "getEventType", "()Ltech/figure/classification/asset/verifier/provenance/ACContractEvent;", "handleEvent", "", "parameters", "Ltech/figure/classification/asset/verifier/event/EventHandlerParameters;", "(Ltech/figure/classification/asset/verifier/event/EventHandlerParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifier"})
public final class DefaultVerifyAssetEventHandler
implements AssetClassificationEventHandler {
    @NotNull
    public static final DefaultVerifyAssetEventHandler INSTANCE = new DefaultVerifyAssetEventHandler();
    @NotNull
    private static final ACContractEvent eventType = ACContractEvent.VERIFY_ASSET;

    private DefaultVerifyAssetEventHandler() {
    }

    @Override
    @NotNull
    public ACContractEvent getEventType() {
        return eventType;
    }

    @Override
    @Nullable
    public Object handleEvent(@NotNull EventHandlerParameters parameters, @NotNull Continuation<? super Unit> $completion) {
        AssetScopeAttribute assetScopeAttribute;
        AssetClassificationEvent event = parameters.component1();
        ACClient acClient = parameters.component2();
        ProvenanceAccountDetail verifierAccount = parameters.component3();
        Channel<VerifierEvent> eventChannel = parameters.component6();
        String messagePrefix = "[VERIFY ASSET | Tx: " + event.getSourceEvent().getTxHash() + " | Asset " + event.getScopeAddress();
        if (event.getVerifierAddress() == null) {
            Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredNoVerifierAddress(event, this.getEventType(), null, 4, null), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (!Intrinsics.areEqual((Object)event.getVerifierAddress(), (Object)parameters.getVerifierAccount().getBech32Address())) {
            Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredDifferentVerifierAddress(event, this.getEventType(), verifierAccount.getBech32Address(), null, 8, null), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        String string = event.getScopeAddress();
        if (string == null) {
            DefaultVerifyAssetEventHandler $this$handleEvent_u24lambda_u2d0 = this;
            boolean bl = false;
            Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredMissingScopeAddress(event, $this$handleEvent_u24lambda_u2d0.getEventType(), messagePrefix + " Expected the verify asset event to include a scope address, but it was missing"), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        String scopeAddress2 = string;
        try {
            assetScopeAttribute = acClient.queryAssetScopeAttributeByScopeAddress(scopeAddress2);
        }
        catch (Throwable t) {
            Object object = eventChannel.send((Object)new VerifierEvent.EventIgnoredMissingScopeAttribute(event, this.getEventType(), messagePrefix + " Intercepted verification did not point to a scope with a scope attribute", t), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        AssetScopeAttribute scopeAttribute = assetScopeAttribute;
        if (scopeAttribute.getOnboardingStatus() == AssetOnboardingStatus.PENDING) {
            Object object = eventChannel.send((Object)new VerifierEvent.VerifyEventFailedOnboardingStatusStillPending(event, scopeAttribute, messagePrefix + " Verification did not successfully move onboarding status from pending"), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = eventChannel.send((Object)new VerifierEvent.VerifyEventSuccessful(event, scopeAttribute), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

