/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.classification.asset.localtools.tool;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Message;
import cosmos.tx.v1beta1.ServiceOuterClass;
import cosmos.tx.v1beta1.TxOuterClass;
import cosmwasm.wasm.v1.Tx;
import cosmwasm.wasm.v1.Types;
import io.provenance.client.grpc.BaseReqSigner;
import io.provenance.client.grpc.PbClient;
import io.provenance.client.grpc.Signer;
import io.provenance.client.protobuf.extensions.ProtobufKt;
import io.provenance.name.v1.MsgBindNameRequest;
import io.provenance.name.v1.NameRecord;
import io.provenance.scope.util.ByteStringExtensionsKt;
import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.figure.classification.asset.client.client.base.ACClient;
import tech.figure.classification.asset.client.client.base.ContractIdentifier;
import tech.figure.classification.asset.client.domain.execute.AddAssetDefinitionExecute;
import tech.figure.classification.asset.client.domain.model.EntityDetail;
import tech.figure.classification.asset.client.domain.model.VerifierDetail;
import tech.figure.classification.asset.localtools.extensions.BroadcastTxResponseExtensionsKt;
import tech.figure.classification.asset.localtools.extensions.ByteArrayExtensionsKt;
import tech.figure.classification.asset.localtools.extensions.GenericExtensionsKt;
import tech.figure.classification.asset.localtools.extensions.PbClientExtensionsKt;
import tech.figure.classification.asset.localtools.feign.GitHubApiClient;
import tech.figure.classification.asset.localtools.models.contract.AssetClassificationContractInstantiate;
import tech.figure.classification.asset.localtools.models.github.GitHubAsset;
import tech.figure.classification.asset.localtools.models.github.GitHubReleaseResponse;
import tech.figure.classification.asset.localtools.tool.ContractWasmLocation;
import tech.figure.classification.asset.localtools.tool.SetupACTool;
import tech.figure.classification.asset.localtools.tool.SetupACToolConfig;
import tech.figure.spec.AssetSpecification;
import tech.figure.spec.AssetSpecificationKt;
import tech.figure.spec.RecordSpecConfig;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Ltech/figure/classification/asset/localtools/tool/SetupACTool;", "", "()V", "OBJECT_MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getOBJECT_MAPPER", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "OBJECT_MAPPER$delegate", "Lkotlin/Lazy;", "downloadAndInstantiateSmartContract", "", "config", "Ltech/figure/classification/asset/localtools/tool/SetupACToolConfig;", "getCompressedWasmBytes", "", "setupAssetDefinitions", "", "contractAddress", "setupContract", "localtools"})
public final class SetupACTool {
    @NotNull
    public static final SetupACTool INSTANCE = new SetupACTool();
    @NotNull
    private static final Lazy OBJECT_MAPPER$delegate = LazyKt.lazy((Function0)OBJECT_MAPPER.2.INSTANCE);

    private SetupACTool() {
    }

    private final ObjectMapper getOBJECT_MAPPER() {
        Lazy lazy = OBJECT_MAPPER$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    public final void setupContract(@NotNull SetupACToolConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String contractAddress = this.downloadAndInstantiateSmartContract(config);
        this.setupAssetDefinitions(config, contractAddress);
    }

    private final byte[] getCompressedWasmBytes(SetupACToolConfig config) {
        Object object;
        Object object2;
        block16: {
            Object it;
            Object $this$singleOrNull$iv;
            block13: {
                Object v2;
                block12: {
                    Object object3;
                    block15: {
                        GitHubApiClient client;
                        block14: {
                            object2 = config.getWasmLocation();
                            if (!(object2 instanceof ContractWasmLocation.GitHub)) break block13;
                            config.getLogger().invoke("Querying GitHub for a download link to the asset classification smart contract's WASM file");
                            client = GitHubApiClient.Companion.new();
                            boolean bl = false;
                            object3 = ((ContractWasmLocation.GitHub)config.getWasmLocation()).getContractReleaseTag();
                            if (object3 == null) break block14;
                            String tag = object3;
                            boolean bl2 = false;
                            GitHubReleaseResponse gitHubReleaseResponse = client.getReleaseByTag("provenance-io", "asset-classification-smart-contract", tag);
                            object3 = gitHubReleaseResponse;
                            if (gitHubReleaseResponse != null) break block15;
                        }
                        object3 = client.getLatestRelease("provenance-io", "asset-classification-smart-contract");
                    }
                    $this$singleOrNull$iv = ((GitHubReleaseResponse)object3).getAssets();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    Iterator iterator = $this$singleOrNull$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        GitHubAsset it2 = (GitHubAsset)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"asset_classification_smart_contract.wasm")) continue;
                        if (found$iv) {
                            v2 = null;
                            break block12;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v2 = !found$iv ? null : single$iv;
                }
                String p0 = ((GitHubAsset)GenericExtensionsKt.checkNotNullAc(v2, (Function0<String>)((Function0)getCompressedWasmBytes.3.INSTANCE))).getBrowserDownloadUrl();
                boolean bl = false;
                it = $this$singleOrNull$iv = new URL(p0);
                boolean bl3 = false;
                config.getLogger().invoke("Found WASM file at browser download link [" + (URL)it + "]. Downloading...");
                it = $this$singleOrNull$iv = (Object)TextStreamsKt.readBytes((URL)$this$singleOrNull$iv);
                boolean bl4 = false;
                config.getLogger().invoke("Successfully downloaded wasm file and got uncompressed bytes of size [" + ((Object)it).length + "]");
                object = $this$singleOrNull$iv;
                break block16;
            }
            if (object2 instanceof ContractWasmLocation.LocalFile) {
                File file;
                $this$singleOrNull$iv = config.getWasmLocation();
                if ($this$singleOrNull$iv instanceof ContractWasmLocation.LocalFile.AbsolutePath) {
                    file = new File(((ContractWasmLocation.LocalFile.AbsolutePath)config.getWasmLocation()).getAbsoluteFilePath());
                } else if ($this$singleOrNull$iv instanceof ContractWasmLocation.LocalFile.ProjectResource) {
                    String p0 = ClassLoader.getSystemResource(((ContractWasmLocation.LocalFile.ProjectResource)config.getWasmLocation()).getResourcePath()).getFile();
                    boolean bl = false;
                    file = new File(p0);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                it = $this$singleOrNull$iv = file;
                boolean bl = false;
                config.getLogger().invoke("Loading asset classification smart contract bytes from local file [" + ((File)it).getAbsolutePath() + "]");
                object = FilesKt.readBytes((File)$this$singleOrNull$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object it = object2 = (Object)object;
        boolean bl = false;
        config.getLogger().invoke("GZipping wasm file bytes to compress initial size [" + ((Object)it).length + "]");
        Object bytes = object2 = (Object)ByteArrayExtensionsKt.gzipAc((byte[])object2);
        boolean bl5 = false;
        config.getLogger().invoke("Successfully compressed wasm bytes. Final byte size: [" + ((Object)bytes).length + "]");
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final String downloadAndInstantiateSmartContract(SetupACToolConfig config) {
        void $this$mapTo$iv$iv;
        void instantiate;
        void accessConfig;
        void storeCode;
        Types.AccessConfig.Builder builder;
        Tx.MsgStoreCode.Builder builder2;
        byte[] wasmBytes = this.getCompressedWasmBytes(config);
        config.getLogger().invoke("Storing code on Provenance Blockchain using address [" + config.getContractAdminAccount().getBech32Address() + "] as the contract admin");
        Tx.MsgStoreCode.Builder builder3 = builder2 = Tx.MsgStoreCode.newBuilder();
        PbClient pbClient = config.getPbClient();
        boolean $i$a$-also-SetupACTool$downloadAndInstantiateSmartContract$codeId$22 = false;
        Types.AccessConfig.Builder builder4 = builder = Types.AccessConfig.newBuilder();
        void var10_11 = storeCode;
        boolean $i$a$-also-SetupACTool$downloadAndInstantiateSmartContract$codeId$1$22 = false;
        accessConfig.setAddress(config.getContractAdminAccount().getBech32Address());
        accessConfig.setPermission(Types.AccessType.ACCESS_TYPE_ONLY_ADDRESS);
        var10_11.setInstantiatePermission(builder.build());
        storeCode.setSender(config.getContractAdminAccount().getBech32Address());
        storeCode.setWasmByteCode(ByteStringExtensionsKt.toByteString((byte[])wasmBytes));
        long codeId = BroadcastTxResponseExtensionsKt.getCodeIdAc(PbClientExtensionsKt.broadcastTxAcMessage$default(pbClient, tech.figure.classification.asset.util.extensions.GenericExtensionsKt.wrapListAc((Object)builder2.build()), config.getContractAdminAccount(), null, 1.1, null, false, 52, null));
        config.getLogger().invoke("Successfully stored WASM and got code id [" + codeId + "]");
        config.getLogger().invoke("Instantiating asset classification smart contract at code id [" + codeId + "]");
        Tx.MsgStoreCode.Builder $i$a$-also-SetupACTool$downloadAndInstantiateSmartContract$codeId$22 = builder3 = Tx.MsgInstantiateContract.newBuilder();
        pbClient = config.getPbClient();
        boolean bl = false;
        instantiate.setAdmin(config.getContractAdminAccount().getBech32Address());
        instantiate.setCodeId(codeId);
        instantiate.setLabel("asset-classification");
        instantiate.setSender(config.getContractAdminAccount().getBech32Address());
        instantiate.setMsg(new AssetClassificationContractInstantiate("asset", false, CollectionsKt.emptyList(), true).toBase64Msg(INSTANCE.getOBJECT_MAPPER()));
        String contractAddress = BroadcastTxResponseExtensionsKt.getContractAddressAc(PbClientExtensionsKt.broadcastTxAcMessage$default(pbClient, tech.figure.classification.asset.util.extensions.GenericExtensionsKt.wrapListAc((Object)builder3.build()), config.getContractAdminAccount(), null, 1.1, null, false, 52, null));
        config.getLogger().invoke("Successfully instantiated the asset classification smart contract with address [" + contractAddress + "]");
        Tx.MsgStoreCode.Builder acClient = builder3 = ACClient.Companion.getDefault$default((ACClient.Companion)ACClient.Companion, (ContractIdentifier)((ContractIdentifier)new ContractIdentifier.Address(contractAddress)), (PbClient)config.getPbClient(), null, (int)4, null);
        boolean bl2 = false;
        Iterable $this$map$iv = config.getContractAliasNames();
        boolean $i$f$map = false;
        Iterable $i$a$-also-SetupACTool$downloadAndInstantiateSmartContract$codeId$1$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void alias;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            config.getLogger().invoke("Generating restricted contract lookup alias [" + (String)alias + "] using contract admin address [" + config.getContractAdminAccount().getBech32Address() + "]");
            char[] cArray = new char[]{'.'};
            List it = StringsKt.split$default((CharSequence)((CharSequence)alias), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean bl4 = false;
            Pair pair = TuplesKt.to((Object)CollectionsKt.first((List)it), (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)it, (int)1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            String childName = (String)pair.component1();
            String parentName = (String)pair.component2();
            collection.add(MsgBindNameRequest.newBuilder().setParent(NameRecord.newBuilder().setName(parentName).setAddress(config.getContractAdminAccount().getBech32Address()).setRestricted(false)).setRecord(NameRecord.newBuilder().setName(childName).setAddress(contractAddress).setRestricted(true)).build());
        }
        List aliasMessages = (List)destination$iv$iv;
        boolean bl5 = false;
        config.getLogger().invoke("Binding all alias names in a single transaction using contract admin address [" + config.getContractAdminAccount().getBech32Address() + "]");
        PbClientExtensionsKt.broadcastTxAcMessage$default(config.getPbClient(), aliasMessages, config.getContractAdminAccount(), null, 0.0, null, false, 60, null);
        return contractAddress;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupAssetDefinitions(SetupACToolConfig config, String contractAddress) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = AssetSpecificationKt.getAssetSpecifications();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NameRecord.Builder nameRecord;
            NameRecord.Builder builder;
            AssetSpecification specification = (AssetSpecification)element$iv$iv;
            boolean bl = false;
            Object object = (RecordSpecConfig)CollectionsKt.singleOrNull((List)specification.getRecordSpecConfigs());
            if (object == null || (object = object.getName()) == null) {
                throw new IllegalStateException(("Got unexpected record spec configs list size [" + specification.getRecordSpecConfigs().size() + "] for asset specification with display name [" + specification.getScopeSpecConfig().getName() + "]").toString());
            }
            Object assetType = object;
            config.getLogger().invoke("Generating create scope spec messages for asset type [" + (String)assetType + "]");
            List messages = CollectionsKt.toMutableList((Collection)specification.specificationMsgs(config.getContractAdminAccount().getBech32Address()));
            config.getLogger().invoke("Generating add asset definition message to asset classification contract for asset type [" + (String)assetType + "]");
            Collection collection = messages;
            ACClient aCClient = ACClient.Companion.getDefault$default((ACClient.Companion)ACClient.Companion, (ContractIdentifier)((ContractIdentifier)new ContractIdentifier.Address(contractAddress)), (PbClient)config.getPbClient(), null, (int)4, null);
            String string = specification.getScopeSpecConfig().getName();
            String string2 = config.getVerifierBech32Address();
            BigInteger bigInteger = config.getAssetDefinitionOnboardingCostOverrides().get(assetType);
            if (bigInteger == null) {
                bigInteger = new BigInteger("100000");
            }
            Tx.MsgExecuteContract msgExecuteContract = aCClient.generateAddAssetDefinitionMsg(new AddAssetDefinitionExecute((String)assetType, string, tech.figure.classification.asset.util.extensions.GenericExtensionsKt.wrapListAc((Object)new VerifierDetail(string2, bigInteger, "nhash", CollectionsKt.emptyList(), new EntityDetail("Figure Tech Verifier: " + (String)assetType, "The standard asset classification verifier provided by Figure Technologies", "https://figure.tech", "https://github.com/FigureTechnologies/asset-classification-libs"))), Boolean.valueOf(true), Boolean.valueOf(false)), config.getContractAdminAccount().getBech32Address());
            collection.add(msgExecuteContract);
            config.getLogger().invoke("Generating bind name message of type [" + (String)assetType + ".asset] to contract address [" + contractAddress + "] for future attribute writes");
            collection = messages;
            Tx.MsgExecuteContract bindName = msgExecuteContract = MsgBindNameRequest.newBuilder();
            boolean bl2 = false;
            NameRecord.Builder builder2 = builder = NameRecord.newBuilder();
            Tx.MsgExecuteContract msgExecuteContract2 = bindName;
            boolean bl3 = false;
            nameRecord.setName("asset");
            nameRecord.setAddress(config.getAssetNameAdminAccount().getBech32Address());
            msgExecuteContract2.setParent(builder.build());
            nameRecord = builder = NameRecord.newBuilder();
            msgExecuteContract2 = bindName;
            boolean bl4 = false;
            nameRecord.setName((String)assetType);
            nameRecord.setAddress(contractAddress);
            nameRecord.setRestricted(true);
            msgExecuteContract2.setRecord(builder.build());
            msgExecuteContract = msgExecuteContract.build();
            collection.add(msgExecuteContract);
            list$iv$iv = messages;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List messages = (List)destination$iv$iv;
        config.getLogger().invoke("Broadcasting all generated messages...");
        $this$flatMap$iv = messages;
        PbClient pbClient = config.getPbClient();
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ProtobufKt.toAny$default((Message)it, null, (int)1, null));
        }
        BaseReqSigner[] baseReqSignerArray = new BaseReqSigner[]{new BaseReqSigner((Signer)config.getContractAdminAccount().toAccountSigner(), 0, null, 6, null), new BaseReqSigner((Signer)config.getAssetNameAdminAccount().toAccountSigner(), 0, null, 6, null)};
        BaseReqSigner[] response = baseReqSignerArray = PbClient.estimateAndBroadcastTx$default((PbClient)pbClient, (TxOuterClass.TxBody)ProtobufKt.toTxBody$default((Iterable)((List)destination$iv$iv), null, null, (int)3, null), (List)CollectionsKt.listOf((Object[])baseReqSignerArray), (ServiceOuterClass.BroadcastMode)ServiceOuterClass.BroadcastMode.BROADCAST_MODE_BLOCK, (Double)1.2, null, (int)16, null);
        boolean bl = false;
        if (tech.figure.classification.asset.util.extensions.BroadcastTxResponseExtensionsKt.isErrorAc((ServiceOuterClass.BroadcastTxResponse)response)) {
            throw new IllegalStateException("FAILED to fully create all scope specifications, add asset definitions, and bind asset names to the smart contract. Got raw log: " + response.getTxResponse().getRawLog());
        }
    }
}

