/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.classification.asset.client.domain.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.protobuf.ByteString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.classification.asset.client.domain.model.AssetIdentifier;
import tech.figure.classification.asset.client.domain.query.base.ContractQuery;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonTypeName(value="query_asset_scope_attributes")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u001f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\tH\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ltech/figure/classification/asset/client/domain/query/QueryAssetScopeAttributes;", "T", "Ltech/figure/classification/asset/client/domain/query/base/ContractQuery;", "identifier", "Ltech/figure/classification/asset/client/domain/model/AssetIdentifier;", "(Ltech/figure/classification/asset/client/domain/model/AssetIdentifier;)V", "getIdentifier", "()Ltech/figure/classification/asset/client/domain/model/AssetIdentifier;", "queryFailureMessage", "", "getQueryFailureMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "client"})
public final class QueryAssetScopeAttributes<T>
implements ContractQuery {
    @NotNull
    private final AssetIdentifier<T> identifier;
    @JsonIgnore
    @NotNull
    private final String queryFailureMessage;

    public QueryAssetScopeAttributes(@NotNull AssetIdentifier<T> identifier) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        this.identifier = identifier;
        this.queryFailureMessage = "Query all asset scope attributes by id " + this.identifier;
    }

    @NotNull
    public final AssetIdentifier<T> getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public String getQueryFailureMessage() {
        return this.queryFailureMessage;
    }

    @Override
    @NotNull
    public ByteString toBase64Msg(@NotNull ObjectMapper objectMapper) {
        return ContractQuery.DefaultImpls.toBase64Msg(this, objectMapper);
    }

    @NotNull
    public final AssetIdentifier<T> component1() {
        return this.identifier;
    }

    @NotNull
    public final QueryAssetScopeAttributes<T> copy(@NotNull AssetIdentifier<T> identifier) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        return new QueryAssetScopeAttributes<T>(identifier);
    }

    public static /* synthetic */ QueryAssetScopeAttributes copy$default(QueryAssetScopeAttributes queryAssetScopeAttributes, AssetIdentifier assetIdentifier, int n, Object object) {
        if ((n & 1) != 0) {
            assetIdentifier = queryAssetScopeAttributes.identifier;
        }
        return queryAssetScopeAttributes.copy(assetIdentifier);
    }

    @NotNull
    public String toString() {
        return "QueryAssetScopeAttributes(identifier=" + this.identifier + ")";
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueryAssetScopeAttributes)) {
            return false;
        }
        QueryAssetScopeAttributes queryAssetScopeAttributes = (QueryAssetScopeAttributes)other;
        return Intrinsics.areEqual(this.identifier, queryAssetScopeAttributes.identifier);
    }
}

