/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.classification.asset.client.domain.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.provenance.scope.util.MetadataAddress;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\r\u000eJ\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u0004H\u0017R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Ltech/figure/classification/asset/client/domain/model/AssetIdentifier;", "T", "", "type", "", "getType", "()Ljava/lang/String;", "value", "getValue", "()Ljava/lang/Object;", "getAssetUuid", "Ljava/util/UUID;", "getScopeAddress", "AssetUuid", "ScopeAddress", "Ltech/figure/classification/asset/client/domain/model/AssetIdentifier$AssetUuid;", "Ltech/figure/classification/asset/client/domain/model/AssetIdentifier$ScopeAddress;", "client"})
public interface AssetIdentifier<T> {
    @NotNull
    public String getType();

    public T getValue();

    @JsonIgnore
    @NotNull
    public UUID getAssetUuid();

    @JsonIgnore
    @NotNull
    public String getScopeAddress();

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonPropertyOrder(value={"type", "value"})
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ltech/figure/classification/asset/client/domain/model/AssetIdentifier$AssetUuid;", "Ltech/figure/classification/asset/client/domain/model/AssetIdentifier;", "Ljava/util/UUID;", "value", "(Ljava/util/UUID;)V", "type", "", "getType", "()Ljava/lang/String;", "getValue", "()Ljava/util/UUID;", "client"})
    public static final class AssetUuid
    implements AssetIdentifier<UUID> {
        @NotNull
        private final UUID value;
        @NotNull
        private final String type;

        public AssetUuid(@NotNull UUID value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.type = "asset_uuid";
        }

        @Override
        @NotNull
        public UUID getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @JsonIgnore
        @NotNull
        public UUID getAssetUuid() {
            return DefaultImpls.getAssetUuid(this);
        }

        @Override
        @JsonIgnore
        @NotNull
        public String getScopeAddress() {
            return DefaultImpls.getScopeAddress(this);
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonPropertyOrder(value={"type", "value"})
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Ltech/figure/classification/asset/client/domain/model/AssetIdentifier$ScopeAddress;", "Ltech/figure/classification/asset/client/domain/model/AssetIdentifier;", "", "value", "(Ljava/lang/String;)V", "type", "getType", "()Ljava/lang/String;", "getValue", "client"})
    public static final class ScopeAddress
    implements AssetIdentifier<String> {
        @NotNull
        private final String value;
        @NotNull
        private final String type;

        public ScopeAddress(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.type = "scope_address";
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @JsonIgnore
        @NotNull
        public UUID getAssetUuid() {
            return DefaultImpls.getAssetUuid(this);
        }

        @Override
        @JsonIgnore
        @NotNull
        public String getScopeAddress() {
            return DefaultImpls.getScopeAddress(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @JsonIgnore
        @NotNull
        public static <T> UUID getAssetUuid(@NotNull AssetIdentifier<T> this_) {
            UUID uUID;
            AssetIdentifier<T> assetIdentifier = this_;
            if (assetIdentifier instanceof AssetUuid) {
                uUID = ((AssetUuid)this_).getValue();
            } else if (assetIdentifier instanceof ScopeAddress) {
                uUID = MetadataAddress.Companion.fromBech32(((ScopeAddress)this_).getValue()).getPrimaryUuid();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return uUID;
        }

        @JsonIgnore
        @NotNull
        public static <T> String getScopeAddress(@NotNull AssetIdentifier<T> this_) {
            String string;
            AssetIdentifier<T> assetIdentifier = this_;
            if (assetIdentifier instanceof AssetUuid) {
                string = MetadataAddress.Companion.forScope(((AssetUuid)this_).getValue()).toString();
            } else if (assetIdentifier instanceof ScopeAddress) {
                string = ((ScopeAddress)this_).getValue();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
    }
}

