/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.aggregate.repository.database;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.ravendb.client.documents.DocumentStore;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.session.IDocumentSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import tech.figure.aggregate.common.DBConfig;
import tech.figure.aggregate.common.LoggingKt;
import tech.figure.aggregate.repository.RepositoryBase;
import tech.figure.aggregate.repository.model.checkpoint.BlockHeightCheckpoint;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0004J\u0019\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Ltech/figure/aggregate/repository/database/RavenDB;", "Ltech/figure/aggregate/repository/RepositoryBase;", "dbConfig", "Ltech/figure/aggregate/common/DBConfig;", "(Ltech/figure/aggregate/common/DBConfig;)V", "log", "Lorg/slf4j/Logger;", "store", "Lnet/ravendb/client/documents/IDocumentStore;", "kotlin.jvm.PlatformType", "getBlockCheckpoint", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openSession", "Lnet/ravendb/client/documents/session/IDocumentSession;", "saveChanges", "", "session", "writeBlockCheckpoint", "blockHeight", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "repository"})
@SourceDebugExtension(value={"SMAP\nRavenDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RavenDB.kt\ntech/figure/aggregate/repository/database/RavenDB\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public class RavenDB
implements RepositoryBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final IDocumentStore store;
    @NotNull
    private final Logger log;
    @NotNull
    public static final String CHECKPOINT_ID = "BlockHeightCheckpoint";

    /*
     * WARNING - void declaration
     */
    public RavenDB(@NotNull DBConfig dbConfig) {
        void it;
        DocumentStore documentStore;
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        DocumentStore documentStore2 = documentStore = new DocumentStore(dbConfig.getCacheUri(), dbConfig.getCacheCheckpoint());
        RavenDB ravenDB = this;
        boolean bl = false;
        it.getConventions().setMaxNumberOfRequestsPerSession(dbConfig.getDbMaxConnections());
        ravenDB.store = documentStore.initialize();
        this.log = LoggingKt.logger((Object)this);
    }

    @Override
    @Nullable
    public Object writeBlockCheckpoint(long blockHeight, @NotNull Continuation<? super Unit> $completion) {
        return RavenDB.writeBlockCheckpoint$suspendImpl(this, blockHeight, $completion);
    }

    static /* synthetic */ Object writeBlockCheckpoint$suspendImpl(RavenDB $this, long blockHeight, Continuation<? super Unit> $completion) {
        IDocumentSession session = $this.openSession();
        BlockHeightCheckpoint height = (BlockHeightCheckpoint)session.load(BlockHeightCheckpoint.class, CHECKPOINT_ID);
        if (height == null) {
            BlockHeightCheckpoint checkpoint = new BlockHeightCheckpoint(null, blockHeight, 1, null);
            session.store((Object)checkpoint, CHECKPOINT_ID);
        } else {
            height.setBlockHeight(blockHeight);
        }
        $this.saveChanges(session);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getBlockCheckpoint(@NotNull Continuation<? super Long> $completion) {
        return RavenDB.getBlockCheckpoint$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object getBlockCheckpoint$suspendImpl(RavenDB $this, Continuation<? super Long> $completion) {
        BlockHeightCheckpoint blockHeightCheckpoint = (BlockHeightCheckpoint)$this.openSession().load(BlockHeightCheckpoint.class, CHECKPOINT_ID);
        return blockHeightCheckpoint != null ? Boxing.boxLong((long)blockHeightCheckpoint.getBlockHeight()) : null;
    }

    @NotNull
    protected final IDocumentSession openSession() {
        ObjectMapper objectMapper;
        ObjectMapper $this$openSession_u24lambda_u241 = objectMapper = ExtensionsKt.jacksonObjectMapper();
        boolean bl = false;
        $this$openSession_u24lambda_u241.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ObjectMapper mapper = objectMapper;
        this.store.getConventions().setEntityMapper(mapper);
        IDocumentSession iDocumentSession = this.store.openSession();
        Intrinsics.checkNotNullExpressionValue((Object)iDocumentSession, (String)"store.openSession()");
        return iDocumentSession;
    }

    protected final void saveChanges(@NotNull IDocumentSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        session.saveChanges();
        session.close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/figure/aggregate/repository/database/RavenDB$Companion;", "", "()V", "CHECKPOINT_ID", "", "repository"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

