/*
 * Decompiled with CFR 0.152.
 */
package tech.ferus.util.sql.h2;

import javax.annotation.Nonnull;
import tech.ferus.util.sql.core.BasicDatabase;

public class H2Database
extends BasicDatabase {
    @Nonnull
    private final String path;
    private final boolean memory;

    public H2Database() {
        this("", true);
    }

    public H2Database(@Nonnull String path) {
        super("h2");
        this.path = path;
        this.memory = false;
    }

    public H2Database(@Nonnull String path, boolean memory) {
        super("h2");
        this.path = path;
        this.memory = memory;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public boolean isMemory() {
        return this.memory;
    }

    @Override
    public void configure() {
        if (this.isMemory()) {
            this.getDataSource().setJdbcUrl("jdbc:h2:mem:" + this.path);
        } else {
            this.getDataSource().setJdbcUrl("jdbc:h2:" + this.path);
        }
    }
}

