/*
 * Decompiled with CFR 0.152.
 */
package tech.ferus.util.sql.core;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import tech.ferus.util.sql.api.Database;
import tech.ferus.util.sql.core.DefaultDatabase;

public abstract class BasicDatabase
implements Database {
    @Nonnull
    private final String protocol;
    @Nonnull
    private final ComboPooledDataSource dataSource;
    private boolean configured = false;

    public BasicDatabase(@Nonnull String protocol) {
        this.protocol = protocol;
        this.dataSource = new ComboPooledDataSource();
    }

    @Override
    @Nonnull
    public String getProtocol() {
        return this.protocol;
    }

    @Nonnull
    public ComboPooledDataSource getDataSource() {
        if (!this.configured) {
            this.configure();
            this.configured = true;
        }
        return this.dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public boolean isDefaultDatabase() {
        return DefaultDatabase.isDefaultDatabase(this);
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }
}

