/*
 * Decompiled with CFR 0.152.
 */
package tech.ferus.util.sql.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ferus.util.sql.api.Database;
import tech.ferus.util.sql.api.HandleResults;
import tech.ferus.util.sql.api.Preparer;
import tech.ferus.util.sql.api.ReturnResults;
import tech.ferus.util.sql.core.DefaultDatabase;

public class BasicSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicSql.class);

    public static void execute(@Nonnull String statement) {
        BasicSql.execute(DefaultDatabase.getDatabase(), statement, s -> {});
    }

    public static void execute(@Nonnull String statement, @Nonnull Preparer preparer) {
        BasicSql.execute(DefaultDatabase.getDatabase(), statement, preparer);
    }

    public static void execute(@Nonnull Database database, @Nonnull String statement) {
        BasicSql.execute(database, statement, s -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(@Nonnull Database database, @Nonnull String statement, @Nonnull Preparer preparer) {
        Connection c = null;
        PreparedStatement s = null;
        LOGGER.debug("Attempting to execute statement: {}", (Object)statement);
        try {
            c = database.getConnection();
            s = c.prepareStatement(statement);
            preparer.prepare(s);
            s.execute();
            LOGGER.debug("Finished executing statement: {}", (Object)statement);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to execute statement: {}", (Object)statement, (Object)e);
        }
        finally {
            BasicSql.close(statement, c, s, null);
        }
    }

    public static void query(@Nonnull String statement, @Nonnull HandleResults handle) {
        BasicSql.query(DefaultDatabase.getDatabase(), statement, s -> {}, handle);
    }

    public static void query(@Nonnull String statement, @Nonnull Preparer preparer, @Nonnull HandleResults handle) {
        BasicSql.query(DefaultDatabase.getDatabase(), statement, preparer, handle);
    }

    public static void query(@Nonnull Database database, @Nonnull String statement, @Nonnull HandleResults handle) {
        BasicSql.query(database, statement, s -> {}, handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void query(@Nonnull Database database, @Nonnull String statement, @Nonnull Preparer preparer, @Nonnull HandleResults handle) {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet r = null;
        LOGGER.debug("Attempting to query: {}", (Object)statement);
        try {
            c = database.getConnection();
            s = c.prepareStatement(statement);
            preparer.prepare(s);
            r = s.executeQuery();
            handle.execute(r);
            LOGGER.debug("Finished querying: {}", (Object)statement);
        }
        catch (SQLException e) {
            try {
                LOGGER.error("Failed to execute query: {}", (Object)statement, (Object)e);
            }
            catch (Throwable throwable) {
                BasicSql.close(statement, c, s, r);
                throw throwable;
            }
            BasicSql.close(statement, c, s, r);
        }
        BasicSql.close(statement, c, s, r);
    }

    public static <T> Optional<T> returnQuery(@Nonnull String statement, @Nonnull ReturnResults<T> handle) {
        return BasicSql.returnQuery(DefaultDatabase.getDatabase(), statement, s -> {}, handle);
    }

    public static <T> Optional<T> returnQuery(@Nonnull String statement, @Nonnull Preparer preparer, @Nonnull ReturnResults<T> handle) {
        return BasicSql.returnQuery(DefaultDatabase.getDatabase(), statement, preparer, handle);
    }

    public static <T> Optional<T> returnQuery(@Nonnull Database database, @Nonnull String statement, @Nonnull ReturnResults<T> handle) {
        return BasicSql.returnQuery(database, statement, s -> {}, handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Optional<T> returnQuery(@Nonnull Database database, @Nonnull String statement, @Nonnull Preparer preparer, @Nonnull ReturnResults<T> handle) {
        Optional<T> optional;
        Connection c = null;
        PreparedStatement s = null;
        ResultSet r = null;
        LOGGER.debug("Attempting to query: {}", (Object)statement);
        try {
            c = database.getConnection();
            s = c.prepareStatement(statement);
            preparer.prepare(s);
            r = s.executeQuery();
            Optional<T> results = Optional.ofNullable(handle.execute(r));
            LOGGER.debug("Finished querying: {}", (Object)statement);
            optional = results;
        }
        catch (SQLException e) {
            Optional optional2;
            try {
                LOGGER.error("Failed to execute query: {}", (Object)statement, (Object)e);
                optional2 = Optional.empty();
            }
            catch (Throwable throwable) {
                BasicSql.close(statement, c, s, r);
                throw throwable;
            }
            BasicSql.close(statement, c, s, r);
            return optional2;
        }
        BasicSql.close(statement, c, s, r);
        return optional;
    }

    private static void close(@Nonnull String statement, @Nullable Connection c, @Nullable Statement s, @Nullable ResultSet r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (SQLException e) {
                LOGGER.error("Failed to close ResultSet for statement: {}", (Object)statement);
            }
        }
        if (s != null) {
            try {
                s.close();
            }
            catch (SQLException e) {
                LOGGER.error("Failed to close Statement for statement: {}", (Object)statement);
            }
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (SQLException e) {
                LOGGER.error("Failed to close Connection for statement: {}", (Object)statement);
            }
        }
        LOGGER.debug("Finished closing objects related to statement: {}", (Object)statement);
    }
}

