/*
 * Decompiled with CFR 0.152.
 */
package tech.ferus.util.sql.core;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import tech.ferus.util.sql.api.Database;

public final class DefaultDatabase {
    private static Database defaultDatabase = null;

    public static Connection getConnection() throws SQLException {
        if (DefaultDatabase.isDefaultDatabaseSet()) {
            throw new IllegalStateException("Default database hasn't been set.");
        }
        return defaultDatabase.getConnection();
    }

    public static Database getDatabase() {
        return defaultDatabase;
    }

    public static boolean isDefaultDatabaseSet() {
        return defaultDatabase != null;
    }

    public static void setDefaultDatabase(@Nonnull Database defaultDatabase) {
        DefaultDatabase.defaultDatabase = defaultDatabase;
    }

    public static boolean isDefaultDatabase(@Nonnull Database database) {
        return DefaultDatabase.isDefaultDatabaseSet() && defaultDatabase == database;
    }
}

