/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.servicewrapper.service;

import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import tech.esphero.servicewrapper.mapper.Mapper;

public abstract class WrapperService<T, ID, REQUEST, RESPONSE> {
    private final JpaRepository<T, ID> repository;
    private final Mapper<T, REQUEST, RESPONSE> mapper;

    public RESPONSE save(REQUEST request) {
        T entity = this.mapper.toEntity(request);
        return this.mapper.toResponse(this.repository.save(entity));
    }

    public Optional<RESPONSE> findById(ID id) {
        return this.repository.findById(id).map(this.mapper::toResponse);
    }

    public void deleteById(ID id) {
        Optional existingEntity = this.repository.findById(id);
        if (!existingEntity.isPresent()) {
            throw new IllegalArgumentException("Entity not found for ID: " + String.valueOf(id));
        }
        this.repository.deleteById(id);
    }

    public List<RESPONSE> findAll() {
        return this.mapper.toResponseList(this.repository.findAll());
    }

    public Page<RESPONSE> findAll(Pageable pageable) {
        return this.repository.findAll(pageable).map(this.mapper::toResponse);
    }

    public RESPONSE update(ID id, REQUEST request) {
        Object existingEntity = this.repository.findById(id).orElseThrow(() -> new IllegalArgumentException("Entity not found with id: " + String.valueOf(id)));
        Object updatedEntity = this.mapper.toEntity(request);
        this.copyNonNullProperties(updatedEntity, existingEntity);
        updatedEntity = this.repository.save(updatedEntity);
        return this.mapper.toResponse(updatedEntity);
    }

    private void copyNonNullProperties(T source, T target) {
        BeanUtils.copyProperties(source, target, (String[])this.getNullPropertyNames(source));
    }

    private String[] getNullPropertyNames(T source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        return (String[])Arrays.stream(src.getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(arg_0 -> WrapperService.lambda$getNullPropertyNames$1((BeanWrapper)src, arg_0)).toArray(String[]::new);
    }

    protected JpaRepository<T, ID> getRepository() {
        return this.repository;
    }

    protected Mapper<T, REQUEST, RESPONSE> getMapper() {
        return this.mapper;
    }

    @Generated
    public WrapperService(JpaRepository<T, ID> repository, Mapper<T, REQUEST, RESPONSE> mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }

    private static /* synthetic */ boolean lambda$getNullPropertyNames$1(BeanWrapper src, String propertyName) {
        return src.getPropertyValue(propertyName) == null;
    }
}

