/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.multitenant.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tech.esphero.multitenant.config.AwsSecretsManagerConfig;
import tech.esphero.multitenant.model.Tenant;

@Service
public class TenantService {
    @Value(value="${aws.secretsManager.multitenantSecretName:dev-multitenant-config}")
    private String multitenantSecretName;
    private final AwsSecretsManagerConfig secretsManagerConfig;
    private final ObjectMapper objectMapper;

    @Autowired
    public TenantService(AwsSecretsManagerConfig secretsManagerConfig, ObjectMapper objectMapper) {
        this.secretsManagerConfig = secretsManagerConfig;
        this.objectMapper = objectMapper;
    }

    public List<Tenant> findAll() {
        try {
            String tenantsJson = this.secretsManagerConfig.getSecret(this.multitenantSecretName);
            return (List)this.objectMapper.readValue(tenantsJson, (TypeReference)new TypeReference<List<Tenant>>(this){});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load tenants from AWS Secrets Manager", e);
        }
    }
}

