/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.multitenant.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import tech.esphero.multitenant.context.TenantContext;
import tech.esphero.multitenant.datasource.DataSourceManager;
import tech.esphero.multitenant.exception.InvalidTenantException;

@Component
public class TenantInterceptor
implements HandlerInterceptor {
    @Value(value="${tenant.header-name:X-TENANT-ID}")
    private String tenantHeaderName;
    private final DataSourceManager dataSourceManager;

    public TenantInterceptor(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tenantId = request.getHeader(this.tenantHeaderName);
        if (tenantId != null && !tenantId.isEmpty()) {
            if (!this.dataSourceManager.tenantExists(tenantId)) {
                throw new InvalidTenantException("Tenant does not exist for value: " + tenantId);
            }
        } else {
            throw new InvalidTenantException("Missing header: " + this.tenantHeaderName);
        }
        TenantContext.setCurrentTenant(tenantId);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        TenantContext.clear();
    }
}

