/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.multitenant.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import tech.esphero.multitenant.model.Tenant;
import tech.esphero.multitenant.model.TenantDatasource;
import tech.esphero.multitenant.service.TenantService;

@Component
public class DataSourceManager {
    private Map<Object, Object> dataSources = new HashMap<Object, Object>();
    @Value(value="${tenant.type}")
    private String tenantType;
    @Autowired
    private TenantService tenantService;

    @PostConstruct
    private void loadTenants() {
        List<Tenant> tenants = this.tenantService.findAll();
        for (Tenant tenant : tenants) {
            TenantDatasource datasource = tenant.getDatasources().stream().filter(t -> t.getType().toString().equalsIgnoreCase(this.tenantType)).findFirst().orElseThrow(() -> new RuntimeException(String.format("No datasource found of type %s", this.tenantType)));
            HikariDataSource ds = this.getHikariDataSource(tenant, datasource);
            this.dataSources.put(tenant.getTenantId(), ds);
        }
    }

    private HikariDataSource getHikariDataSource(Tenant tenant, TenantDatasource datasource) {
        HikariConfig config = new HikariConfig();
        config.setUsername(datasource.getUsername());
        config.setPassword(datasource.getPassword());
        config.setJdbcUrl(String.format("jdbc:postgresql://%s:%d/%s", datasource.getHost(), datasource.getPort(), datasource.getDatabase()));
        config.setDriverClassName(datasource.getDriverClassName());
        config.setPoolName(String.format("%s-%s", this.tenantType.toLowerCase(), tenant.getTenantId().toLowerCase()));
        config.setMaximumPoolSize(datasource.getMaxPoolSize().intValue());
        config.setMinimumIdle(datasource.getMinimumIdle().intValue());
        config.setIdleTimeout((long)datasource.getIdleTimeout().intValue());
        HikariDataSource ds = new HikariDataSource(config);
        return ds;
    }

    public boolean tenantExists(String tenantId) {
        return this.dataSources.containsKey(tenantId);
    }

    @Generated
    public Map<Object, Object> getDataSources() {
        return this.dataSources;
    }
}

