/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.multitenant.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import tech.esphero.multitenant.interceptor.TenantInterceptor;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    private final TenantInterceptor tenantInterceptor;
    @Value(value="${tenant.interceptor.pattern:/api/**}")
    private String tenantPattern;

    @Autowired
    public WebConfig(TenantInterceptor tenantInterceptor) {
        this.tenantInterceptor = tenantInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.tenantInterceptor).addPathPatterns(new String[]{this.tenantPattern});
    }
}

