/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.multitenant.config;

import java.util.Map;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import tech.esphero.multitenant.config.TenantMigrationConfig;
import tech.esphero.multitenant.datasource.DataSourceManager;

@Component
public class FlywayTenantMigration
implements InitializingBean {
    @Value(value="${tenant.migration.path:db/migration/tenant}")
    private String tenantMigrationPath;
    private static final Logger log = LoggerFactory.getLogger(TenantMigrationConfig.class);
    @Autowired
    private DataSourceManager dataSourceManager;

    public void migrate() {
        log.info("Starting flyway migrations for masterDataSource");
        for (Map.Entry<Object, Object> entry : this.dataSourceManager.getDataSources().entrySet()) {
            log.info("Migrating tenant data source {}", entry.getKey());
            Flyway.configure().dataSource((DataSource)entry.getValue()).locations(new String[]{this.tenantMigrationPath}).baselineOnMigrate(true).load().migrate();
        }
    }

    @DependsOn(value={"masterDatasourceMigration"})
    public void afterPropertiesSet() throws Exception {
        this.migrate();
    }
}

