/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.multitenant.config;

import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

@Component
public class AwsSecretsManagerConfig {
    @Value(value="${aws.accessKeyId}")
    private String accessId;
    @Value(value="${aws.secretAccessKey}")
    private String secretAccessKey;
    @Value(value="${aws.secretsManager.region}")
    private String region;
    private SecretsManagerClient secretsManagerClient;

    @PostConstruct
    private void initializeSecretsManagerClient() {
        this.secretsManagerClient = (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)this.region))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessId, (String)this.secretAccessKey)))).build();
    }

    public String getSecret(String secretName) {
        GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        GetSecretValueResponse response = this.secretsManagerClient.getSecretValue(request);
        return response.secretString();
    }
}

