/*
 * Decompiled with CFR 0.152.
 */
package tech.esphero.multitenant;

import jakarta.persistence.EntityManagerFactory;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import tech.esphero.multitenant.datasource.DataSourceManager;
import tech.esphero.multitenant.datasource.MultiTenantDataSource;

@Configuration
@ComponentScan(value={"tech.esphero.multitenant"})
@ConditionalOnMissingBean(name={"dataSource"})
@ConditionalOnProperty(prefix="tenant", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableJpaRepositories(basePackages={"${tenant.repositories}"}, entityManagerFactoryRef="multitenantEntityManagerFactory", transactionManagerRef="multitenantTransactionManager")
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class MultitenantAutoConfiguration {
    @Bean(name={"dataSourceManager"})
    public DataSourceManager dataSourceManager() {
        return new DataSourceManager();
    }

    @Bean(name={"multitenantDataSource"})
    public DataSource multitenantDataSource(@Qualifier(value="dataSourceManager") DataSourceManager dataSourceManager) {
        MultiTenantDataSource dataSource = new MultiTenantDataSource();
        dataSource.setTargetDataSources(dataSourceManager.getDataSources());
        dataSource.setDefaultTargetDataSource(dataSourceManager.getDataSources().entrySet().iterator().next().getValue());
        dataSource.afterPropertiesSet();
        return dataSource;
    }

    @Bean(name={"multitenantEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean multitenantEntityManagerFactory(@Qualifier(value="multitenantDataSource") DataSource dataSource, Environment environment) {
        String entitiesPackage = environment.getProperty("tenant.entities");
        if (entitiesPackage == null) {
            throw new IllegalStateException("Property 'tenant.entities' not found");
        }
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(dataSource);
        em.setPackagesToScan(new String[]{entitiesPackage});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        em.setPersistenceUnitName("multitenant-persistence-unit");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.hbm2ddl.auto", "none");
        properties.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        em.setJpaPropertyMap(properties);
        return em;
    }

    @Bean(name={"multitenantTransactionManager"})
    public PlatformTransactionManager multitenantTransactionManager(@Qualifier(value="multitenantEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }
}

