/*
 * Decompiled with CFR 0.152.
 */
package tech.ecom.egts.library.utils;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.ecom.egts.library.exception.EgtsAdapterException;
import tech.ecom.egts.library.exception.EgtsExceptionErrorCode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0011\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u0003\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u000f\u001a\u00020\u0006*\u00020\f\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\f\u001a\u000f\u0010\u0011\u001a\u00020\u0012*\u00020\f\u00a2\u0006\u0002\u0010\u0013\u001a\u000f\u0010\u0014\u001a\u00020\u0015*\u00020\f\u00a2\u0006\u0002\u0010\u0016\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u001b\u001a\n\u0010\u001c\u001a\u00020\u001b*\u00020\u001a\u001a\n\u0010\u001d\u001a\u00020\u0003*\u00020\u0007\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u001f\u001a\u00020\u0007*\u00020\u0001\u001a\n\u0010\u001f\u001a\u00020\u0007*\u00020\u0006\u001a\u0014\u0010\u001f\u001a\u00020\u0007*\u00020\u0012\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!\u001a\u0014\u0010\u001f\u001a\u00020\u0007*\u00020\u0015\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#\u001a\n\u0010$\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010%\u001a\u00020\u0003*\u00020\u0007\u001a\n\u0010&\u001a\u00020\u0007*\u00020\u0001\u001a\u000f\u0010'\u001a\u00020\u0012*\u00020\u0007\u00a2\u0006\u0002\u0010(\u001a\u000f\u0010)\u001a\u00020\u0015*\u00020\u0007\u00a2\u0006\u0002\u0010*\u001a\n\u0010+\u001a\u00020\u0007*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006,"}, d2={"INT_BYTE_LENGTH", "", "LATIN1_ENCODING_NAME", "", "SHORT_BYTE_LENGTH", "calculateCrc16", "", "", "calculateCrc8", "hexStringToByteArray", "readByte", "", "Ljava/io/ByteArrayInputStream;", "readByteToUnsignedInt", "readInt", "readShort", "readThreeBytesToPositiveInt", "readUInt", "Lkotlin/UInt;", "(Ljava/io/ByteArrayInputStream;)I", "readUShort", "Lkotlin/UShort;", "(Ljava/io/ByteArrayInputStream;)S", "roundToFirstDecimal", "", "toBitCharValue", "", "", "toBoolean", "toHexString", "toIntFromLittleEndian", "toLittleEndianByteArray", "toLittleEndianByteArray-WZ4Q5Ns", "(I)[B", "toLittleEndianByteArray-xj2QHRw", "(S)[B", "toShortFromLittleEndian", "toStringFromVdtByteArray", "toThreeByteLittleEndianByteArray", "toUIntFromLittleEndian", "([B)I", "toUShortFromLittleEndian", "([B)S", "toVdtByteArray", "library"})
@SourceDebugExtension(value={"SMAP\nBinaryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryHelper.kt\ntech/ecom/egts/library/utils/BinaryHelperKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n483#2,11:141\n1549#3:152\n1620#3,3:153\n*S KotlinDebug\n*F\n+ 1 BinaryHelper.kt\ntech/ecom/egts/library/utils/BinaryHelperKt\n*L\n108#1:141,11\n110#1:152\n110#1:153,3\n*E\n"})
public final class BinaryHelperKt {
    public static final int INT_BYTE_LENGTH = 4;
    public static final int SHORT_BYTE_LENGTH = 2;
    @NotNull
    public static final String LATIN1_ENCODING_NAME = "ISO-8859-1";

    public static final boolean toBoolean(char $this$toBoolean) {
        return $this$toBoolean == '1';
    }

    public static final char toBitCharValue(boolean $this$toBitCharValue) {
        return $this$toBitCharValue ? (char)'1' : '0';
    }

    public static final byte readByte(@NotNull ByteArrayInputStream $this$readByte) {
        Intrinsics.checkNotNullParameter((Object)$this$readByte, (String)"<this>");
        return $this$readByte.readNBytes(1)[0];
    }

    public static final int readInt(@NotNull ByteArrayInputStream $this$readInt) {
        Intrinsics.checkNotNullParameter((Object)$this$readInt, (String)"<this>");
        byte[] byArray = $this$readInt.readNBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return BinaryHelperKt.toIntFromLittleEndian(byArray);
    }

    public static final int readUInt(@NotNull ByteArrayInputStream $this$readUInt) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt, (String)"<this>");
        byte[] byArray = $this$readUInt.readNBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return BinaryHelperKt.toUIntFromLittleEndian(byArray);
    }

    public static final short readShort(@NotNull ByteArrayInputStream $this$readShort) {
        Intrinsics.checkNotNullParameter((Object)$this$readShort, (String)"<this>");
        byte[] byArray = $this$readShort.readNBytes(2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return BinaryHelperKt.toShortFromLittleEndian(byArray);
    }

    public static final short readUShort(@NotNull ByteArrayInputStream $this$readUShort) {
        Intrinsics.checkNotNullParameter((Object)$this$readUShort, (String)"<this>");
        byte[] byArray = $this$readUShort.readNBytes(2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return BinaryHelperKt.toUShortFromLittleEndian(byArray);
    }

    public static final int readByteToUnsignedInt(@NotNull ByteArrayInputStream $this$readByteToUnsignedInt) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteToUnsignedInt, (String)"<this>");
        return Byte.toUnsignedInt($this$readByteToUnsignedInt.readNBytes(1)[0]);
    }

    public static final int readThreeBytesToPositiveInt(@NotNull ByteArrayInputStream $this$readThreeBytesToPositiveInt) {
        Intrinsics.checkNotNullParameter((Object)$this$readThreeBytesToPositiveInt, (String)"<this>");
        byte[] bytes = $this$readThreeBytesToPositiveInt.readNBytes(3);
        boolean bl = false;
        if (bytes.length < 3) {
            throw new EgtsAdapterException(EgtsExceptionErrorCode.EGTS_DECODE_EXCEPTION, "Less than three bytes available to read.", null, 4, null);
        }
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16;
    }

    @NotNull
    public static final byte[] toLittleEndianByteArray(int $this$toLittleEndianByteArray) {
        byte[] byArray = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt($this$toLittleEndianByteArray).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] toThreeByteLittleEndianByteArray(int $this$toThreeByteLittleEndianByteArray) {
        if ($this$toThreeByteLittleEndianByteArray < 0 || $this$toThreeByteLittleEndianByteArray > 0xFFFFFF) {
            throw new EgtsAdapterException(EgtsExceptionErrorCode.EGTS_ENCODE_EXCEPTION, "Value must be non-negative and less than 16,777,216.", null, 4, null);
        }
        byte[] byArray = BinaryHelperKt.toLittleEndianByteArray($this$toThreeByteLittleEndianByteArray);
        int n = 0;
        int n2 = 3;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    @NotNull
    public static final byte[] toLittleEndianByteArray(short $this$toLittleEndianByteArray) {
        byte[] byArray = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort($this$toLittleEndianByteArray).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] toLittleEndianByteArray-xj2QHRw(short $this$toLittleEndianByteArray_u2dxj2QHRw) {
        return BinaryHelperKt.toLittleEndianByteArray($this$toLittleEndianByteArray_u2dxj2QHRw);
    }

    @NotNull
    public static final byte[] toLittleEndianByteArray-WZ4Q5Ns(int $this$toLittleEndianByteArray_u2dWZ4Q5Ns) {
        return BinaryHelperKt.toLittleEndianByteArray($this$toLittleEndianByteArray_u2dWZ4Q5Ns);
    }

    public static final int toIntFromLittleEndian(@NotNull byte[] $this$toIntFromLittleEndian) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntFromLittleEndian, (String)"<this>");
        if ($this$toIntFromLittleEndian.length != 4) {
            throw new EgtsAdapterException(EgtsExceptionErrorCode.INCORRECT_BINARY_HELPER_USAGE, "bytearray should contain exactly 4 bytes to be properly converted to Int", null, 4, null);
        }
        return ByteBuffer.wrap($this$toIntFromLittleEndian).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static final short toShortFromLittleEndian(@NotNull byte[] $this$toShortFromLittleEndian) {
        Intrinsics.checkNotNullParameter((Object)$this$toShortFromLittleEndian, (String)"<this>");
        if ($this$toShortFromLittleEndian.length != 2) {
            throw new EgtsAdapterException(EgtsExceptionErrorCode.INCORRECT_BINARY_HELPER_USAGE, "bytearray should contain exactly 2 bytes to be properly converted to Short", null, 4, null);
        }
        return ByteBuffer.wrap($this$toShortFromLittleEndian).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public static final short toUShortFromLittleEndian(@NotNull byte[] $this$toUShortFromLittleEndian) {
        Intrinsics.checkNotNullParameter((Object)$this$toUShortFromLittleEndian, (String)"<this>");
        return UShort.constructor-impl((short)BinaryHelperKt.toShortFromLittleEndian($this$toUShortFromLittleEndian));
    }

    public static final int toUIntFromLittleEndian(@NotNull byte[] $this$toUIntFromLittleEndian) {
        Intrinsics.checkNotNullParameter((Object)$this$toUIntFromLittleEndian, (String)"<this>");
        return UInt.constructor-impl((int)BinaryHelperKt.toIntFromLittleEndian($this$toUIntFromLittleEndian));
    }

    public static final double roundToFirstDecimal(double $this$roundToFirstDecimal) {
        return (double)MathKt.roundToInt((double)($this$roundToFirstDecimal * (double)10)) / 10.0;
    }

    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        StringBuilder hexString = new StringBuilder();
        for (byte b : $this$toHexString) {
            String string = "x%02x";
            Object[] objectArray = new Object[]{b};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            hexString.append(string2);
        }
        String string = hexString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final byte[] toVdtByteArray(@NotNull String $this$toVdtByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toVdtByteArray, (String)"<this>");
        String string = $this$toVdtByteArray;
        Charset charset = Charset.forName(LATIN1_ENCODING_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public static final String toStringFromVdtByteArray(@NotNull byte[] $this$toStringFromVdtByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringFromVdtByteArray, (String)"<this>");
        byte[] byArray = $this$toStringFromVdtByteArray;
        Charset charset = Charset.forName(LATIN1_ENCODING_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] hexStringToByteArray(@NotNull String $this$hexStringToByteArray) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hexStringToByteArray, (String)"<this>");
        String $this$filterNot$iv = $this$hexStringToByteArray;
        boolean $i$f$filterNot = false;
        CharSequence charSequence = $this$filterNot$iv;
        Object destination$iv$iv = new StringBuilder();
        boolean $i$f$filterNotTo = false;
        for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
            boolean bl = false;
            if (it == 'x') continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable $this$map$iv = StringsKt.chunked((CharSequence)string, (int)2);
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((byte)Integer.parseInt(it, CharsKt.checkRadix((int)16)));
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }

    public static final int calculateCrc8(@NotNull byte[] $this$calculateCrc8) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc8, (String)"<this>");
        int crc = -1;
        for (byte b : $this$calculateCrc8) {
            crc = (byte)(crc ^ b);
            for (int i = 0; i < 8; ++i) {
                crc = (crc & 0x80) != 0 ? (byte)(crc << 1 ^ 0x31) : (byte)(crc << 1);
            }
        }
        return crc;
    }

    public static final short calculateCrc16(@NotNull byte[] $this$calculateCrc16) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc16, (String)"<this>");
        int crc = 65535;
        int polynomial = 4129;
        for (byte b : $this$calculateCrc16) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return (short)(crc & 0xFFFF);
    }
}

