/*
 * Decompiled with CFR 0.152.
 */
package tech.ecom.egts.library.encoder.sfrd.record.subrecord;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.ecom.egts.library.constants.EgtsConstants;
import tech.ecom.egts.library.encoder.sfrd.record.subrecord.AbstractSubRecordEncoder;
import tech.ecom.egts.library.model.sfrd.record.subrecord.SubRecordType;
import tech.ecom.egts.library.model.sfrd.record.subrecord.types.PosSubRecordData;
import tech.ecom.egts.library.utils.BinaryHelperKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0007H\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltech/ecom/egts/library/encoder/sfrd/record/subrecord/PosSubRecordDataEncoder;", "Ltech/ecom/egts/library/encoder/sfrd/record/subrecord/AbstractSubRecordEncoder;", "Ltech/ecom/egts/library/model/sfrd/record/subrecord/types/PosSubRecordData;", "()V", "MAX_UNSIGNED_INT_VALUE", "", "encodeOdometer", "", "odometer", "", "performDecode", "byteArray", "performEncode", "egtsEntity", "library"})
@SourceDebugExtension(value={"SMAP\nPosSubRecordDataEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosSubRecordDataEncoder.kt\ntech/ecom/egts/library/encoder/sfrd/record/subrecord/PosSubRecordDataEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class PosSubRecordDataEncoder
extends AbstractSubRecordEncoder<PosSubRecordData> {
    private final long MAX_UNSIGNED_INT_VALUE = (long)-1 & 0xFFFFFFFFL;

    public PosSubRecordDataEncoder() {
        super(SubRecordType.EGTS_SR_POS_DATA.getId(), SubRecordType.EGTS_SR_POS_DATA.getFieldName());
    }

    @Override
    @NotNull
    protected byte[] performEncode(@NotNull PosSubRecordData egtsEntity) {
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter((Object)egtsEntity, (String)"egtsEntity");
        ByteArrayOutputStream $this$performEncode_u24lambda_u243 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        PosSubRecordData $this$performEncode_u24lambda_u243_u24lambda_u242 = egtsEntity;
        boolean bl2 = false;
        int navigationTimeSeconds = (int)(Instant.ofEpochMilli(egtsEntity.getNavigationTime().getTime()).getEpochSecond() - EgtsConstants.Companion.getEGTS_START_SECONDS());
        $this$performEncode_u24lambda_u243.write(BinaryHelperKt.toLittleEndianByteArray(navigationTimeSeconds));
        double it = egtsEntity.getLatitude();
        boolean bl3 = false;
        int normalizedLatitude = UnsignedKt.doubleToUInt((double)(it * Math.signum(it) / 90.0 * (double)this.MAX_UNSIGNED_INT_VALUE));
        $this$performEncode_u24lambda_u243.write(BinaryHelperKt.toLittleEndianByteArray-WZ4Q5Ns(normalizedLatitude));
        double it2 = $this$performEncode_u24lambda_u243_u24lambda_u242.getLongitude();
        boolean $i$a$-let-PosSubRecordDataEncoder$performEncode$1$1$normalizedLongitude$22 = false;
        int normalizedLongitude = UnsignedKt.doubleToUInt((double)(it2 * Math.signum(it2) / 180.0 * (double)this.MAX_UNSIGNED_INT_VALUE));
        $this$performEncode_u24lambda_u243.write(BinaryHelperKt.toLittleEndianByteArray-WZ4Q5Ns(normalizedLongitude));
        boolean isEasternLongitude = Math.signum($this$performEncode_u24lambda_u243_u24lambda_u242.getLongitude()) == 1.0;
        boolean isNorthernLatitude = Math.signum($this$performEncode_u24lambda_u243_u24lambda_u242.getLatitude()) == 1.0;
        int flagBits = ($this$performEncode_u24lambda_u243_u24lambda_u242.isAltitudePresent() ? 1 : 0) << 7 | (isEasternLongitude ? 0 : 1) << 6 | (isNorthernLatitude ? 0 : 1) << 5 | ($this$performEncode_u24lambda_u243_u24lambda_u242.isMoving() ? 1 : 0) << 4 | ($this$performEncode_u24lambda_u243_u24lambda_u242.isSentFromBlackBox() ? 1 : 0) << 3 | ($this$performEncode_u24lambda_u243_u24lambda_u242.getCoordinateSystem() ? 1 : 0) << 2 | ($this$performEncode_u24lambda_u243_u24lambda_u242.getFix() ? 1 : 0) << 1 | ($this$performEncode_u24lambda_u243_u24lambda_u242.isValid() ? 1 : 0) << 0;
        byte[] $i$a$-let-PosSubRecordDataEncoder$performEncode$1$1$normalizedLongitude$22 = new byte[]{(byte)flagBits};
        $this$performEncode_u24lambda_u243.write($i$a$-let-PosSubRecordDataEncoder$performEncode$1$1$normalizedLongitude$22);
        int roundedSpeed = MathKt.roundToInt((double)($this$performEncode_u24lambda_u243_u24lambda_u242.getSpeed() * (double)10));
        short speedWithClearedTwoBits = UShort.constructor-impl((short)((short)(roundedSpeed & 0x3FFF)));
        int directionHighestBit = $this$performEncode_u24lambda_u243_u24lambda_u242.getDirection() > 255 ? 1 : 0;
        short directionAltSignSpeedCombinedValue = UShort.constructor-impl((short)((short)(speedWithClearedTwoBits | UShort.constructor-impl((short)((short)(directionHighestBit << 15 | $this$performEncode_u24lambda_u243_u24lambda_u242.getAltitudeSign() << 14))))));
        $this$performEncode_u24lambda_u243.write(BinaryHelperKt.toLittleEndianByteArray-xj2QHRw(directionAltSignSpeedCombinedValue));
        int directionLeastSignificantByte = $this$performEncode_u24lambda_u243_u24lambda_u242.getDirection() % 256;
        $this$performEncode_u24lambda_u243.write(directionLeastSignificantByte);
        $this$performEncode_u24lambda_u243.write(this.encodeOdometer($this$performEncode_u24lambda_u243_u24lambda_u242.getOdometer()));
        byte[] byArray = new byte[]{(byte)Integer.parseInt($this$performEncode_u24lambda_u243_u24lambda_u242.getDigitalInputs(), CharsKt.checkRadix((int)2))};
        $this$performEncode_u24lambda_u243.write(byArray);
        byArray = new byte[]{(byte)Integer.parseInt($this$performEncode_u24lambda_u243_u24lambda_u242.getSource(), CharsKt.checkRadix((int)2))};
        $this$performEncode_u24lambda_u243.write(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        return byArray2;
    }

    private final byte[] encodeOdometer(double odometer) {
        ByteArrayOutputStream byteArrayOutputStream;
        int odometerUInt32 = (int)(BinaryHelperKt.roundToFirstDecimal(odometer) * (double)10);
        ByteArrayOutputStream $this$encodeOdometer_u24lambda_u244 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        $this$encodeOdometer_u24lambda_u244.write(BinaryHelperKt.toLittleEndianByteArray(odometerUInt32), 0, 3);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Override
    @NotNull
    protected PosSubRecordData performDecode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        ByteArrayInputStream $this$performDecode_u24lambda_u245 = new ByteArrayInputStream(byteArray);
        boolean bl = false;
        Timestamp navigationTime = new Timestamp(((long)BinaryHelperKt.readInt($this$performDecode_u24lambda_u245) + EgtsConstants.Companion.getEGTS_START_SECONDS()) * 1000L);
        long normalizedLatitude = (long)BinaryHelperKt.readUInt($this$performDecode_u24lambda_u245) & 0xFFFFFFFFL;
        double latitude = (double)normalizedLatitude / (double)this.MAX_UNSIGNED_INT_VALUE * 90.0;
        long normalizedLongitude = (long)BinaryHelperKt.readUInt($this$performDecode_u24lambda_u245) & 0xFFFFFFFFL;
        double longitude = (double)normalizedLongitude / (double)this.MAX_UNSIGNED_INT_VALUE * 180.0;
        int flagBits = $this$performDecode_u24lambda_u245.read();
        boolean isAltitudePresent = (flagBits & 0x80) != 0;
        boolean isEasternLongitude = (flagBits & 0x40) == 0;
        boolean isNorthernLatitude = (flagBits & 0x20) == 0;
        boolean isMoving = (flagBits & 0x10) != 0;
        boolean isBlackBox = (flagBits & 8) != 0;
        boolean coordinateSystem = (flagBits & 4) != 0;
        boolean fix = (flagBits & 2) != 0;
        boolean isValid = (flagBits & 1) != 0;
        int spd8lowestBits = $this$performDecode_u24lambda_u245.read();
        int dirhAltsAndSpd6highestBits = $this$performDecode_u24lambda_u245.read();
        int directionHighestBit = dirhAltsAndSpd6highestBits >> 7 & 1;
        int altitudeSign = dirhAltsAndSpd6highestBits >> 6 & 1;
        int spd6highestBits = dirhAltsAndSpd6highestBits & 0x3F;
        int speed14Bits = spd6highestBits << 8 | spd8lowestBits;
        double speed = BinaryHelperKt.roundToFirstDecimal((double)speed14Bits / 10.0);
        int direction = $this$performDecode_u24lambda_u245.read() + (directionHighestBit == 1 ? 256 : 0);
        byte[] odometerBytes = $this$performDecode_u24lambda_u245.readNBytes(3);
        byte[] byArray = new byte[]{odometerBytes[0], odometerBytes[1], odometerBytes[2], 0};
        double odometer = (double)ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt() / 10.0;
        String string = Integer.toString($this$performDecode_u24lambda_u245.read(), CharsKt.checkRadix((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String digitalInputs = StringsKt.padStart((String)string, (int)8, (char)'0');
        String string2 = Integer.toString($this$performDecode_u24lambda_u245.read(), CharsKt.checkRadix((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String source = StringsKt.padStart((String)string2, (int)8, (char)'0');
        return new PosSubRecordData(navigationTime, isNorthernLatitude ? latitude : -latitude, isEasternLongitude ? longitude : -longitude, isAltitudePresent, isMoving, isBlackBox, coordinateSystem, fix, isValid, altitudeSign, direction, odometer, digitalInputs, source, speed);
    }
}

