/*
 * Decompiled with CFR 0.152.
 */
package tech.ecom.egts.library.encoder.sfrd.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import tech.ecom.egts.library.encoder.AbstractEgtsEncoder;
import tech.ecom.egts.library.encoder.sfrd.record.subrecord.AbstractSubRecordEncoder;
import tech.ecom.egts.library.exception.EgtsAdapterException;
import tech.ecom.egts.library.exception.EgtsExceptionErrorCode;
import tech.ecom.egts.library.model.sfrd.record.RecordData;
import tech.ecom.egts.library.model.sfrd.record.subrecord.SubRecord;
import tech.ecom.egts.library.model.sfrd.record.subrecord.SubRecordData;
import tech.ecom.egts.library.utils.BinaryHelperKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0002R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltech/ecom/egts/library/encoder/sfrd/record/RecordDataEncoder;", "Ltech/ecom/egts/library/encoder/AbstractEgtsEncoder;", "Ltech/ecom/egts/library/model/sfrd/record/RecordData;", "subRecordEncoders", "", "Ltech/ecom/egts/library/encoder/sfrd/record/subrecord/AbstractSubRecordEncoder;", "Ltech/ecom/egts/library/model/sfrd/record/subrecord/SubRecordData;", "(Ljava/util/List;)V", "encodersBySubRecordTypeId", "", "", "performDecode", "byteArray", "", "performEncode", "egtsEntity", "pickAnEncoder", "subRecordTypeId", "library"})
@SourceDebugExtension(value={"SMAP\nRecordDataEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordDataEncoder.kt\ntech/ecom/egts/library/encoder/sfrd/record/RecordDataEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1194#2,2:85\n1222#2,4:87\n*S KotlinDebug\n*F\n+ 1 RecordDataEncoder.kt\ntech/ecom/egts/library/encoder/sfrd/record/RecordDataEncoder\n*L\n18#1:85,2\n18#1:87,4\n*E\n"})
public final class RecordDataEncoder
extends AbstractEgtsEncoder<RecordData> {
    @NotNull
    private final Map<Integer, AbstractSubRecordEncoder<? extends SubRecordData>> encodersBySubRecordTypeId;

    /*
     * WARNING - void declaration
     */
    public RecordDataEncoder(@NotNull List<? extends AbstractSubRecordEncoder<? extends SubRecordData>> subRecordEncoders) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(subRecordEncoders, (String)"subRecordEncoders");
        super("RECORD_DATA");
        Iterable iterable = subRecordEncoders;
        RecordDataEncoder recordDataEncoder = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            AbstractSubRecordEncoder abstractSubRecordEncoder = (AbstractSubRecordEncoder)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getSubRecordTypeId(), element$iv$iv);
        }
        recordDataEncoder.encodersBySubRecordTypeId = destination$iv$iv;
    }

    @Override
    @NotNull
    protected byte[] performEncode(@NotNull RecordData egtsEntity) {
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter((Object)egtsEntity, (String)"egtsEntity");
        ByteArrayOutputStream $this$performEncode_u24lambda_u242 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        for (SubRecord subRecord : egtsEntity.getSubRecordList()) {
            Function0<Unit> function0;
            $this$performEncode_u24lambda_u242.write(subRecord.getSubRecordTypeId());
            if (subRecord.getSubRecordData() != null) {
                SubRecordData subRecordData;
                boolean bl2 = false;
                AbstractSubRecordEncoder<SubRecordData> subRecordEncoder = this.pickAnEncoder(subRecord.getSubRecordTypeId());
                byte[] subRecordDataByteArray = subRecordEncoder.encode(subRecordData);
                int subRecordLength = subRecordDataByteArray.length;
                $this$performEncode_u24lambda_u242.write(BinaryHelperKt.toLittleEndianByteArray((short)subRecordLength));
                $this$performEncode_u24lambda_u242.write(subRecordDataByteArray);
                function0 = Unit.INSTANCE;
                continue;
            }
            function0 = new Function0<Unit>($this$performEncode_u24lambda_u242){
                final /* synthetic */ ByteArrayOutputStream $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(0);
                }

                public final void invoke() {
                    boolean subRecordLength = false;
                    this.$this_apply.write(BinaryHelperKt.toLittleEndianByteArray((short)(subRecordLength ? 1 : 0)));
                }
            };
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Override
    @NotNull
    protected RecordData performDecode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        ByteArrayInputStream $this$performDecode_u24lambda_u243 = new ByteArrayInputStream(byteArray);
        boolean bl = false;
        List subRecordList = new ArrayList();
        while ($this$performDecode_u24lambda_u243.available() > 0) {
            int subRecordTypeId = $this$performDecode_u24lambda_u243.read();
            AbstractSubRecordEncoder<SubRecordData> subRecordEncoder = this.pickAnEncoder(subRecordTypeId);
            short subRecordLength = BinaryHelperKt.readShort($this$performDecode_u24lambda_u243);
            if (subRecordLength <= 0) continue;
            byte[] subRecordBytes = $this$performDecode_u24lambda_u243.readNBytes(subRecordLength);
            Intrinsics.checkNotNull((Object)subRecordBytes);
            SubRecordData subRecordData = (SubRecordData)subRecordEncoder.decode(subRecordBytes);
            SubRecord subRecord = new SubRecord(subRecordTypeId, subRecordData);
            subRecordList.add(subRecord);
        }
        return new RecordData(subRecordList);
    }

    private final AbstractSubRecordEncoder<SubRecordData> pickAnEncoder(int subRecordTypeId) {
        AbstractSubRecordEncoder<SubRecordData> abstractSubRecordEncoder = this.encodersBySubRecordTypeId.get(subRecordTypeId);
        if (abstractSubRecordEncoder == null) {
            throw new EgtsAdapterException(EgtsExceptionErrorCode.EGTS_DECODE_EXCEPTION, "no subrecord type with id " + subRecordTypeId + " implemented yes. To implement it: \n1) start from SubRecordType enum (that's not mandatory step. it just helps to keep things organized) \n2) add data class to 'model' package \n3) implement appropriate encoder at 'encoder' package. Use subRecordTypeId and fieldName from 1) \n4) add new encoder bean initialization to autoconfiguration \n5) implement test at 'test' package. Use SubRecordType enum entry from 1) to reference subRecordTypeId \n6) use new encoder at your app code. Use SubRecordType enum entry from 1) to reference subRecordTypeId \nyou're awesome!", null, 4, null);
        }
        AbstractSubRecordEncoder<SubRecordData> subRecordEncoder = abstractSubRecordEncoder;
        return subRecordEncoder;
    }
}

