/*
 * Decompiled with CFR 0.152.
 */
package tech.ecom.egts.library.encoder.sfrd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.ecom.egts.library.encoder.AbstractEgtsEncoder;
import tech.ecom.egts.library.encoder.sfrd.record.RecordDataEncoder;
import tech.ecom.egts.library.model.sfrd.ServiceDataRecords;
import tech.ecom.egts.library.model.sfrd.record.RecordData;
import tech.ecom.egts.library.model.sfrd.record.ServiceDataRecord;
import tech.ecom.egts.library.model.sfrd.record.ServiceType;
import tech.ecom.egts.library.utils.BinaryHelperKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltech/ecom/egts/library/encoder/sfrd/ServiceDataRecordsEncoder;", "Ltech/ecom/egts/library/encoder/AbstractEgtsEncoder;", "Ltech/ecom/egts/library/model/sfrd/ServiceDataRecords;", "recordDataEncoder", "Ltech/ecom/egts/library/encoder/sfrd/record/RecordDataEncoder;", "(Ltech/ecom/egts/library/encoder/sfrd/record/RecordDataEncoder;)V", "performDecode", "byteArray", "", "performEncode", "egtsEntity", "buildFlagBits", "", "Ltech/ecom/egts/library/model/sfrd/record/ServiceDataRecord;", "library"})
@SourceDebugExtension(value={"SMAP\nServiceDataRecordsEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceDataRecordsEncoder.kt\ntech/ecom/egts/library/encoder/sfrd/ServiceDataRecordsEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1855#2:140\n1856#2:142\n1#3:141\n*S KotlinDebug\n*F\n+ 1 ServiceDataRecordsEncoder.kt\ntech/ecom/egts/library/encoder/sfrd/ServiceDataRecordsEncoder\n*L\n26#1:140\n26#1:142\n*E\n"})
public final class ServiceDataRecordsEncoder
extends AbstractEgtsEncoder<ServiceDataRecords> {
    @NotNull
    private final RecordDataEncoder recordDataEncoder;

    public ServiceDataRecordsEncoder(@NotNull RecordDataEncoder recordDataEncoder) {
        Intrinsics.checkNotNullParameter((Object)recordDataEncoder, (String)"recordDataEncoder");
        super("SERVICE_DATA_RECORDS");
        this.recordDataEncoder = recordDataEncoder;
    }

    @Override
    @NotNull
    protected byte[] performEncode(@NotNull ServiceDataRecords egtsEntity) {
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter((Object)egtsEntity, (String)"egtsEntity");
        ByteArrayOutputStream $this$performEncode_u24lambda_u244 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        Iterable $this$forEach$iv = egtsEntity.getSdrList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object object2;
            Object p0;
            ServiceDataRecord serviceDataRecord = (ServiceDataRecord)element$iv;
            boolean bl2 = false;
            ServiceDataRecord $this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242 = serviceDataRecord;
            boolean bl3 = false;
            byte[] recordData = this.recordDataEncoder.encode($this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242.getRecordData());
            int recordLength = recordData.length;
            $this$performEncode_u24lambda_u244.write(BinaryHelperKt.toLittleEndianByteArray((short)recordLength));
            $this$performEncode_u24lambda_u244.write(BinaryHelperKt.toLittleEndianByteArray-xj2QHRw($this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242.getRecordNumber-Mh2AYeg()));
            $this$performEncode_u24lambda_u244.write(this.buildFlagBits($this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242));
            Object object3 = $this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242.getObjectIdentifier-0hXNFcg();
            if (object3 != null) {
                byte[] byArray = BinaryHelperKt.toLittleEndianByteArray-WZ4Q5Ns(object3.unbox-impl());
                object3 = byArray;
                if (byArray != null) {
                    p0 = object3;
                    boolean bl4 = false;
                    $this$performEncode_u24lambda_u244.write((byte[])p0);
                }
            }
            if ((object2 = $this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242.getEventIdentifier-0hXNFcg()) != null) {
                byte[] byArray = BinaryHelperKt.toLittleEndianByteArray-WZ4Q5Ns(object2.unbox-impl());
                object2 = byArray;
                if (byArray != null) {
                    p0 = object2;
                    boolean bl5 = false;
                    $this$performEncode_u24lambda_u244.write((byte[])p0);
                }
            }
            if ((object = $this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242.getTime-0hXNFcg()) != null) {
                byte[] byArray = BinaryHelperKt.toLittleEndianByteArray-WZ4Q5Ns(object.unbox-impl());
                object = byArray;
                if (byArray != null) {
                    p0 = object;
                    boolean bl6 = false;
                    $this$performEncode_u24lambda_u244.write((byte[])p0);
                }
            }
            $this$performEncode_u24lambda_u244.write($this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242.getSourceServiceType().getByteValue());
            $this$performEncode_u24lambda_u244.write($this$performEncode_u24lambda_u244_u24lambda_u243_u24lambda_u242.getRecipientServiceType().getByteValue());
            $this$performEncode_u24lambda_u244.write(recordData);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private final int buildFlagBits(ServiceDataRecord $this$buildFlagBits) {
        CharSequence charSequence;
        StringBuilder $this$buildFlagBits_u24lambda_u245 = charSequence = new StringBuilder();
        boolean bl = false;
        $this$buildFlagBits_u24lambda_u245.append(BinaryHelperKt.toBitCharValue($this$buildFlagBits.getSourceServiceOnDevice()));
        $this$buildFlagBits_u24lambda_u245.append(BinaryHelperKt.toBitCharValue($this$buildFlagBits.getRecipientServiceOnDevice()));
        $this$buildFlagBits_u24lambda_u245.append(BinaryHelperKt.toBitCharValue($this$buildFlagBits.getGroup()));
        $this$buildFlagBits_u24lambda_u245.append($this$buildFlagBits.getRecordProcessingPriority());
        $this$buildFlagBits_u24lambda_u245.append(BinaryHelperKt.toBitCharValue($this$buildFlagBits.getTime-0hXNFcg() != null));
        $this$buildFlagBits_u24lambda_u245.append(BinaryHelperKt.toBitCharValue($this$buildFlagBits.getEventIdentifier-0hXNFcg() != null));
        $this$buildFlagBits_u24lambda_u245.append(BinaryHelperKt.toBitCharValue($this$buildFlagBits.getObjectIdentifier-0hXNFcg() != null));
        String string = charSequence.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence it = charSequence = string;
        boolean bl2 = false;
        this.getLogger().trace("flag bits string is {}", (Object)it);
        CharSequence flagBits = charSequence;
        return Integer.parseInt((String)flagBits, 2);
    }

    @Override
    @NotNull
    protected ServiceDataRecords performDecode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.getLogger().debug("parsing ServiceDataRecords {}", (Object)BinaryHelperKt.toHexString(byteArray));
        ByteArrayInputStream $this$performDecode_u24lambda_u2414 = new ByteArrayInputStream(byteArray);
        boolean bl = false;
        int recordCounter = 0;
        List sdrList = new ArrayList();
        while ($this$performDecode_u24lambda_u2414.available() > 0) {
            String recordProcessingPriority;
            ServiceType it6;
            UInt uInt;
            UInt eventIdentifier;
            UInt objectIdentifier;
            short s;
            this.getLogger().trace("parsing {}-th service data record", (Object)(++recordCounter));
            short recordLength = UShort.constructor-impl((short)BinaryHelperKt.readShort($this$performDecode_u24lambda_u2414));
            short it2 = s = UShort.constructor-impl((short)BinaryHelperKt.readShort($this$performDecode_u24lambda_u2414));
            boolean bl2 = false;
            this.getLogger().trace("its record number defined as {}", (Object)UShort.box-impl((short)it2));
            short recordNumber = s;
            String string = Integer.toString($this$performDecode_u24lambda_u2414.read(), CharsKt.checkRadix((int)2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String it3 = it2 = StringsKt.padStart((String)string, (int)8, (char)'0');
            boolean bl3 = false;
            this.getLogger().trace("flags bit read as {}", (Object)it3);
            String flags = it2;
            boolean sourceServiceOnDevice = BinaryHelperKt.toBoolean(flags.charAt(0));
            boolean recipientServiceOnDevice = BinaryHelperKt.toBoolean(flags.charAt(1));
            boolean group = BinaryHelperKt.toBoolean(flags.charAt(2));
            Intrinsics.checkNotNullExpressionValue((Object)flags.substring(3, 5), (String)"substring(...)");
            boolean timeFieldExists = BinaryHelperKt.toBoolean(flags.charAt(5));
            boolean eventIdFieldExists = BinaryHelperKt.toBoolean(flags.charAt(6));
            boolean objectIdFieldExists = BinaryHelperKt.toBoolean(flags.charAt(7));
            if (objectIdFieldExists) {
                UInt uInt2 = UInt.box-impl((int)BinaryHelperKt.readUInt($this$performDecode_u24lambda_u2414));
                int it4 = uInt2.unbox-impl();
                boolean bl4 = false;
                this.getLogger().trace("objectIdentifier defined as {}", (Object)UInt.box-impl((int)it4));
                v1 = uInt2;
            } else {
                v1 = objectIdentifier = null;
            }
            if (eventIdFieldExists) {
                UInt it4 = UInt.box-impl((int)BinaryHelperKt.readUInt($this$performDecode_u24lambda_u2414));
                int it5 = it4.unbox-impl();
                boolean bl5 = false;
                this.getLogger().trace("eventIdentifier defined as {}", (Object)UInt.box-impl((int)it5));
                v2 = it4;
            } else {
                v2 = eventIdentifier = null;
            }
            if (timeFieldExists) {
                UInt it5 = UInt.box-impl((int)BinaryHelperKt.readUInt($this$performDecode_u24lambda_u2414));
                int it6 = it5.unbox-impl();
                boolean bl6 = false;
                this.getLogger().trace("time defined as {}", (Object)UInt.box-impl((int)it6));
                uInt = it5;
            } else {
                uInt = null;
            }
            UInt time = uInt;
            ServiceType it7 = it6 = ServiceType.Companion.fromByteValue(BinaryHelperKt.readByte($this$performDecode_u24lambda_u2414));
            boolean bl7 = false;
            this.getLogger().trace("sourceServiceType defined as {}", (Object)it7);
            ServiceType sourceServiceType = it6;
            ServiceType it8 = it7 = ServiceType.Companion.fromByteValue(BinaryHelperKt.readByte($this$performDecode_u24lambda_u2414));
            boolean bl8 = false;
            this.getLogger().trace("recipientServiceType defined as {}", (Object)it8);
            ServiceType recipientServiceType = it7;
            byte[] recordDataBytes = ByteBuffer.wrap($this$performDecode_u24lambda_u2414.readNBytes(recordLength & 0xFFFF)).order(ByteOrder.LITTLE_ENDIAN).array();
            Intrinsics.checkNotNull((Object)recordDataBytes);
            RecordData recordData = (RecordData)this.recordDataEncoder.decode(recordDataBytes);
            ServiceDataRecord serviceDataRecord = new ServiceDataRecord(recordNumber, sourceServiceOnDevice, recipientServiceOnDevice, group, recordProcessingPriority, objectIdentifier, eventIdentifier, time, sourceServiceType, recipientServiceType, recordData, null);
            sdrList.add(serviceDataRecord);
        }
        return new ServiceDataRecords(sdrList);
    }
}

