/*
 * Decompiled with CFR 0.152.
 */
package tech.ecom.egts.library.encoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import tech.ecom.egts.library.encoder.AbstractEgtsEncoder;
import tech.ecom.egts.library.encoder.sfrd.AppServicesFrameDataEncoder;
import tech.ecom.egts.library.encoder.sfrd.ResponseServicesFrameDataEncoder;
import tech.ecom.egts.library.exception.EgtsAdapterException;
import tech.ecom.egts.library.exception.EgtsExceptionErrorCode;
import tech.ecom.egts.library.model.EgtsPacket;
import tech.ecom.egts.library.model.PacketType;
import tech.ecom.egts.library.model.sfrd.AppServicesFrameData;
import tech.ecom.egts.library.model.sfrd.ResponseServicesFrameData;
import tech.ecom.egts.library.model.sfrd.ServicesFrameData;
import tech.ecom.egts.library.utils.BinaryHelperKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ltech/ecom/egts/library/encoder/EgtsPacketEncoder;", "Ltech/ecom/egts/library/encoder/AbstractEgtsEncoder;", "Ltech/ecom/egts/library/model/EgtsPacket;", "appServicesFrameDataEncoder", "Ltech/ecom/egts/library/encoder/sfrd/AppServicesFrameDataEncoder;", "responseServicesFrameDataEncoder", "Ltech/ecom/egts/library/encoder/sfrd/ResponseServicesFrameDataEncoder;", "(Ltech/ecom/egts/library/encoder/sfrd/AppServicesFrameDataEncoder;Ltech/ecom/egts/library/encoder/sfrd/ResponseServicesFrameDataEncoder;)V", "performDecode", "byteArray", "", "performEncode", "egtsEntity", "library"})
@SourceDebugExtension(value={"SMAP\nEgtsPacketEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EgtsPacketEncoder.kt\ntech/ecom/egts/library/encoder/EgtsPacketEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class EgtsPacketEncoder
extends AbstractEgtsEncoder<EgtsPacket> {
    @NotNull
    private final AppServicesFrameDataEncoder appServicesFrameDataEncoder;
    @NotNull
    private final ResponseServicesFrameDataEncoder responseServicesFrameDataEncoder;

    public EgtsPacketEncoder(@NotNull AppServicesFrameDataEncoder appServicesFrameDataEncoder, @NotNull ResponseServicesFrameDataEncoder responseServicesFrameDataEncoder) {
        Intrinsics.checkNotNullParameter((Object)appServicesFrameDataEncoder, (String)"appServicesFrameDataEncoder");
        Intrinsics.checkNotNullParameter((Object)responseServicesFrameDataEncoder, (String)"responseServicesFrameDataEncoder");
        super("EGTS_PACKET");
        this.appServicesFrameDataEncoder = appServicesFrameDataEncoder;
        this.responseServicesFrameDataEncoder = responseServicesFrameDataEncoder;
    }

    @Override
    @NotNull
    protected byte[] performEncode(@NotNull EgtsPacket egtsEntity) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter((Object)egtsEntity, (String)"egtsEntity");
        ByteArrayOutputStream $this$performEncode_u24lambda_u244 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        EgtsPacket $this$performEncode_u24lambda_u244_u24lambda_u243 = egtsEntity;
        boolean bl2 = false;
        byte[] it = byArray = (switch (WhenMappings.$EnumSwitchMapping$0[$this$performEncode_u24lambda_u244_u24lambda_u243.getPacketType().ordinal()]) {
            case 1 -> {
                ServicesFrameData v0 = $this$performEncode_u24lambda_u244_u24lambda_u243.getServicesFrameData();
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type tech.ecom.egts.library.model.sfrd.AppServicesFrameData");
                yield this.appServicesFrameDataEncoder.encode((AppServicesFrameData)v0);
            }
            case 2 -> {
                ServicesFrameData v2 = $this$performEncode_u24lambda_u244_u24lambda_u243.getServicesFrameData();
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type tech.ecom.egts.library.model.sfrd.ResponseServicesFrameData");
                yield this.responseServicesFrameDataEncoder.encode((ResponseServicesFrameData)v2);
            }
            default -> throw new NoWhenBranchMatchedException();
        });
        int n = 0;
        this.getLogger().trace("encoded SFRD as {}", (Object)BinaryHelperKt.toHexString(it));
        byte[] serviceDataByteArray = byArray;
        int frameDataLength = serviceDataByteArray.length;
        $this$performEncode_u24lambda_u244.write($this$performEncode_u24lambda_u244_u24lambda_u243.getProtocolVersion());
        $this$performEncode_u24lambda_u244.write($this$performEncode_u24lambda_u244_u24lambda_u243.getSecurityKeyId());
        $this$performEncode_u24lambda_u244.write(Integer.parseInt($this$performEncode_u24lambda_u244_u24lambda_u243.getPrefix() + $this$performEncode_u24lambda_u244_u24lambda_u243.getRoute() + $this$performEncode_u24lambda_u244_u24lambda_u243.getEncryptionAlg() + $this$performEncode_u24lambda_u244_u24lambda_u243.getCompression() + $this$performEncode_u24lambda_u244_u24lambda_u243.getPriority(), CharsKt.checkRadix((int)2)));
        $this$performEncode_u24lambda_u244.write($this$performEncode_u24lambda_u244_u24lambda_u243.getHeaderLength());
        $this$performEncode_u24lambda_u244.write($this$performEncode_u24lambda_u244_u24lambda_u243.getHeaderEncoding());
        $this$performEncode_u24lambda_u244.write(BinaryHelperKt.toLittleEndianByteArray((short)frameDataLength));
        $this$performEncode_u24lambda_u244.write(BinaryHelperKt.toLittleEndianByteArray-xj2QHRw($this$performEncode_u24lambda_u244_u24lambda_u243.getPacketIdentifier-Mh2AYeg()));
        $this$performEncode_u24lambda_u244.write($this$performEncode_u24lambda_u244_u24lambda_u243.getPacketType().getCode());
        byte[] byArray2 = $this$performEncode_u24lambda_u244.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        int it2 = n = BinaryHelperKt.calculateCrc8(byArray2);
        boolean bl3 = false;
        this.getLogger().trace("calculated header checksum as {}", (Object)it2);
        int headerCheckSum = n;
        $this$performEncode_u24lambda_u244.write(headerCheckSum);
        if (frameDataLength > 0) {
            short s;
            $this$performEncode_u24lambda_u244.write(serviceDataByteArray);
            short it3 = s = BinaryHelperKt.calculateCrc16(serviceDataByteArray);
            boolean bl4 = false;
            this.getLogger().trace("calculated SFRD checksum as {}", (Object)it3);
            short sfrdCheckSum = s;
            $this$performEncode_u24lambda_u244.write(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(sfrdCheckSum).array());
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
        return byArray3;
    }

    @Override
    @NotNull
    protected EgtsPacket performDecode(@NotNull byte[] byteArray) {
        short s;
        short s2;
        int n;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.getLogger().debug("decoding EGTS packet from {}", (Object)BinaryHelperKt.toHexString(byteArray));
        ByteArrayInputStream $this$performDecode_u24lambda_u2416 = new ByteArrayInputStream(byteArray);
        boolean bl = false;
        int it = n = BinaryHelperKt.readByteToUnsignedInt($this$performDecode_u24lambda_u2416);
        boolean bl2 = false;
        if (it != 1) {
            throw new EgtsAdapterException(EgtsExceptionErrorCode.UNSUPPORTED_EGTS_PROTOCOL_VERSION, "Unsupported EGTS protocol version " + it, null, 4, null);
        }
        int protocolVersion = n;
        this.getLogger().trace("protocol version is - {}", (Object)protocolVersion);
        int it2 = it = BinaryHelperKt.readByteToUnsignedInt($this$performDecode_u24lambda_u2416);
        boolean bl3 = false;
        this.getLogger().trace("security key id is - {}", (Object)it2);
        int securityKeyId = it;
        String string = Integer.toString($this$performDecode_u24lambda_u2416.read(), CharsKt.checkRadix((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String it3 = it2 = StringsKt.padStart((String)string, (int)8, (char)'0');
        boolean bl4 = false;
        this.getLogger().trace("flags byte read as {}", (Object)it3);
        String flags = it2;
        String string2 = flags.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String prefix = string2;
        String route = String.valueOf(flags.charAt(2));
        String string3 = flags.substring(3, 5);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String encryptionAlg = string3;
        String compression = String.valueOf(flags.charAt(5));
        String string4 = flags.substring(6, 8);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String priority = string4;
        short it4 = s2 = BinaryHelperKt.readByteToUnsignedInt($this$performDecode_u24lambda_u2416);
        boolean bl5 = false;
        this.getLogger().trace("header length is {}", (Object)it4);
        short headerLength = s2;
        short it5 = it4 = BinaryHelperKt.readByteToUnsignedInt($this$performDecode_u24lambda_u2416);
        boolean bl6 = false;
        this.getLogger().trace("header encoding is {}", (Object)it5);
        short headerEncoding = it4;
        short it6 = it5 = (short)BinaryHelperKt.readShort($this$performDecode_u24lambda_u2416);
        boolean bl7 = false;
        this.getLogger().trace("frame data length is {}", (Object)it6);
        short frameDataLength = it5;
        short it7 = it6 = (short)BinaryHelperKt.readUShort($this$performDecode_u24lambda_u2416);
        boolean bl8 = false;
        this.getLogger().trace("packet identifier is {}", (Object)UShort.box-impl((short)it7));
        short packetIdentifier = it6;
        PacketType it8 = it7 = PacketType.Companion.fromCode(BinaryHelperKt.readByteToUnsignedInt($this$performDecode_u24lambda_u2416));
        boolean bl9 = false;
        this.getLogger().trace("packet type is {}", (Object)it8);
        PacketType packetType = it7;
        int it22 = it7 = BinaryHelperKt.readByteToUnsignedInt($this$performDecode_u24lambda_u2416);
        boolean bl10 = false;
        this.getLogger().trace("header checksum is {}", (Object)it22);
        byte[] it9 = it22 = $this$performDecode_u24lambda_u2416.readNBytes(frameDataLength);
        boolean bl11 = false;
        Logger logger = this.getLogger();
        Intrinsics.checkNotNull((Object)it9);
        logger.trace("service frame data sdrs bytes are {}", (Object)BinaryHelperKt.toHexString(it9));
        byte[] dataFrameBytes = it22;
        ServicesFrameData servicesFrameData = switch (WhenMappings.$EnumSwitchMapping$0[packetType.ordinal()]) {
            case 2 -> {
                Intrinsics.checkNotNull((Object)dataFrameBytes);
                yield (ServicesFrameData)this.responseServicesFrameDataEncoder.decode(dataFrameBytes);
            }
            case 1 -> {
                Intrinsics.checkNotNull((Object)dataFrameBytes);
                yield (ServicesFrameData)this.appServicesFrameDataEncoder.decode(dataFrameBytes);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        short it10 = s = BinaryHelperKt.readShort($this$performDecode_u24lambda_u2416);
        boolean bl12 = false;
        this.getLogger().trace("service frame data sdrs checksum is {}", (Object)it10);
        short servicesFrameDataCheckSum = s;
        if (servicesFrameDataCheckSum != BinaryHelperKt.calculateCrc16(dataFrameBytes)) {
            throw new EgtsAdapterException(EgtsExceptionErrorCode.WRONG_EGTS_DATA_CHECKSUM, "wrong EGTS service frame data checksum", null, 4, null);
        }
        this.getLogger().debug("valid packet");
        return new EgtsPacket(protocolVersion, securityKeyId, prefix, route, encryptionAlg, compression, priority, headerLength, headerEncoding, packetIdentifier, packetType, servicesFrameData, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PacketType.values().length];
            try {
                nArray[PacketType.APP_DATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PacketType.RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

