/*
 * Decompiled with CFR 0.152.
 */
package tech.ecom.egts.library.encoder;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ecom.egts.library.exception.EgtsAdapterException;
import tech.ecom.egts.library.exception.EgtsExceptionErrorCode;
import tech.ecom.egts.library.utils.BinaryHelperKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0004J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0015\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH$\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Ltech/ecom/egts/library/encoder/AbstractEgtsEncoder;", "T", "", "fieldName", "", "(Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "decode", "byteArray", "", "([B)Ljava/lang/Object;", "encode", "egtsEntity", "(Ljava/lang/Object;)[B", "handleDecodeException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleEncodeException", "Ljava/io/IOException;", "logResult", "performDecode", "performEncode", "library"})
@SourceDebugExtension(value={"SMAP\nAbstractEgtsEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractEgtsEncoder.kt\ntech/ecom/egts/library/encoder/AbstractEgtsEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public abstract class AbstractEgtsEncoder<T> {
    @NotNull
    private final String fieldName;
    @NotNull
    private final Logger logger;

    public AbstractEgtsEncoder(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        this.fieldName = fieldName;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final byte[] encode(T egtsEntity) {
        byte[] byArray;
        byte[] byteArray = null;
        try {
            byteArray = this.performEncode(egtsEntity);
        }
        catch (IOException e) {
            this.handleEncodeException(e);
        }
        Intrinsics.checkNotNull((Object)byteArray);
        byte[] it = byArray = byteArray;
        boolean bl = false;
        this.logResult(it);
        return byArray;
    }

    public final T decode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        T egtsEntity = null;
        try {
            egtsEntity = this.performDecode(byteArray);
        }
        catch (IOException e) {
            this.handleDecodeException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.handleDecodeException(e);
        }
        T t = egtsEntity;
        Intrinsics.checkNotNull(t);
        return t;
    }

    @NotNull
    protected abstract byte[] performEncode(T var1);

    protected abstract T performDecode(@NotNull byte[] var1);

    protected final void logResult(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.logger.info("{} field hex representation - {}", (Object)this.fieldName, (Object)BinaryHelperKt.toHexString(byteArray));
    }

    protected final void handleEncodeException(@NotNull IOException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String errorMessage = "caught IO exception while encoding " + this.fieldName;
        this.logger.warn(errorMessage, (Throwable)e);
        throw new EgtsAdapterException(EgtsExceptionErrorCode.EGTS_ENCODE_EXCEPTION, errorMessage, null, 4, null);
    }

    protected final void handleDecodeException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String errorMessage = "caught " + e.getClass().getSimpleName() + " exception while decoding " + this.fieldName;
        this.logger.warn(errorMessage, (Throwable)e);
        throw new EgtsAdapterException(EgtsExceptionErrorCode.EGTS_DECODE_EXCEPTION, errorMessage, null, 4, null);
    }
}

