/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.commons.regex;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.deplant.commons.Strings;
import tech.deplant.commons.regex.AnyOf;
import tech.deplant.commons.regex.GroupOf;
import tech.deplant.commons.regex.NoneOf;
import tech.deplant.commons.regex.Occurences;
import tech.deplant.commons.regex.Special;
import tech.deplant.commons.regex.Symbol;
import tech.deplant.commons.regex.Then;
import tech.deplant.commons.regex.Word;

public sealed interface RegExpBuilder
permits AnyOf, GroupOf, NoneOf, Occurences, Special, Symbol, Then, Word {
    public static final Set<String> RESERVED_SYMBOLS = Set.of("\\", "^", "$", "*", "+", "?", ".", "(", ")", "[", "]", "{", "}", "|");

    public String build();

    default public Pattern toPattern() {
        return Pattern.compile(this.build());
    }

    default public String substr(int startIndex, String source, int ... groups) {
        String newSource = Strings.substr(source, startIndex);
        return this.substr(newSource, groups);
    }

    default public String substr(int startIndex, int endIndex, String source, int ... groups) {
        String newSource = Strings.substr(source, startIndex, endIndex);
        return this.substr(newSource, groups);
    }

    default public String substr(String source, int ... groups) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = this.toPattern().matcher(source);
        if (!matcher.find()) {
            return "";
        }
        if (groups.length == 0) {
            return matcher.group();
        }
        for (int gr : groups) {
            builder.append(matcher.group(gr));
        }
        return builder.toString();
    }
}

