/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.commons;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HexFormat;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import tech.deplant.commons.Objs;

public class Strings {
    private static final Pattern HEXADECIMAL_PATTERN = Pattern.compile("\\p{XDigit}+");

    public static boolean isEmpty(String str) {
        return Objs.isNull(str) || str.isBlank();
    }

    public static boolean isNotEmpty(String str) {
        return Objs.isNotNull(str) && !str.isBlank();
    }

    public static String notEmpty(String str) {
        if (Strings.isEmpty(str)) {
            throw new IllegalArgumentException();
        }
        return str;
    }

    public static String notEmpty(String str, String message) {
        if (Strings.isEmpty(str)) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static <T> void notEmptyDo(String str, Consumer<String> action) {
        if (Strings.isNotEmpty(str)) {
            Objs.notNull(action).accept(str);
        }
    }

    public static <X extends Throwable> String notEmptyThrow(String str, Supplier<? extends X> exceptionSupplier) throws X {
        if (Strings.isEmpty(str)) {
            throw (Throwable)Objs.notNull(exceptionSupplier).get();
        }
        return str;
    }

    public static boolean matchesPattern(String str, String patternString) {
        return Strings.matchesPattern(str, Pattern.compile(patternString));
    }

    public static boolean matchesPattern(String str, Pattern pattern) {
        return pattern.matcher(str).find();
    }

    public static Predicate<String> matchesPatterPredicate(String patternString) {
        return Pattern.compile(patternString).asMatchPredicate();
    }

    private static String cleanHexadecimalPrefix(String str) {
        if (Objs.isNull(str)) {
            return null;
        }
        if (str.startsWith("0x")) {
            return Strings.substr(str, 2);
        }
        if (str.startsWith("-0x")) {
            return Strings.substr(str, 3);
        }
        if (str.startsWith("-")) {
            return Strings.substr(str, 1);
        }
        return str;
    }

    public static boolean isHexadecimal(String str) {
        String stringWithoutPrefix = Strings.cleanHexadecimalPrefix(str);
        return Strings.isNotEmpty(stringWithoutPrefix) && stringWithoutPrefix.length() % 2 == 0 && HEXADECIMAL_PATTERN.matcher(stringWithoutPrefix).matches();
    }

    public static Predicate<String> isHexadecimalPredicate() {
        return HEXADECIMAL_PATTERN.asMatchPredicate();
    }

    public static String notEmptyElse(String str, String defaultStr) {
        return Strings.isNotEmpty(str) ? str : Strings.notEmpty(defaultStr);
    }

    public static String notEmptyElseLazy(String str, Supplier<String> defaultSupplier) {
        return Strings.isNotEmpty(str) ? str : Strings.notEmpty(Objs.notNull(defaultSupplier).get());
    }

    public static boolean notEmptyEquals(String originalStr, String compareStr) {
        return Strings.notEmpty(originalStr).equals(Strings.notEmpty(compareStr));
    }

    public static String substr(String originalStr, int beginIndex) {
        return Strings.substr(originalStr, beginIndex, false);
    }

    public static String substr(String originalStr, int beginIndex, int endIndex) {
        return Strings.substr(originalStr, beginIndex, endIndex, false);
    }

    public static String substr(String originalStr, int beginIndex, boolean reversed) {
        String substred;
        if (Strings.isEmpty(originalStr)) {
            return "";
        }
        int len = originalStr.length();
        if (beginIndex >= len) {
            substred = "";
        } else if (beginIndex <= 0) {
            substred = originalStr;
        } else {
            int begin = reversed ? 0 : beginIndex;
            int end = reversed ? len - beginIndex : len;
            substred = originalStr.substring(begin, end);
        }
        return substred;
    }

    public static String substr(String originalStr, int beginIndex, int endIndex, boolean reversed) {
        String substred;
        if (Strings.isEmpty(originalStr)) {
            return "";
        }
        int len = originalStr.length();
        if (beginIndex >= len || endIndex <= beginIndex || endIndex <= 0) {
            substred = "";
        } else if (beginIndex <= 0 && endIndex >= len) {
            substred = originalStr;
        } else {
            int begin = reversed ? len - endIndex : beginIndex;
            int end = reversed ? len - beginIndex : endIndex;
            substred = originalStr.substring(begin, end);
        }
        return substred;
    }

    public static boolean safeSubstrEquals(String originalStr, int beginIndex, int endIndex, boolean reversed, String compareStr) {
        String substred = Strings.substr(originalStr, beginIndex, endIndex, reversed);
        return Strings.isNotEmpty(compareStr) && Strings.isNotEmpty(substred) && compareStr.equals(substred);
    }

    public static String base64StringToHexString(String base64string) {
        return HexFormat.of().formatHex(Base64.getDecoder().decode(base64string));
    }

    public static String padLeftZeros(String inputString, int length) {
        if (inputString.length() >= length) {
            return inputString;
        }
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length - inputString.length()) {
            sb.append('0');
        }
        sb.append(inputString);
        return sb.toString();
    }

    public static String toHexString(byte[] data) {
        char[] hexCode = "0123456789ABCDEF".toCharArray();
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }

    public static String toHexString(String text) {
        return Strings.toHexString(text.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] hexStringToBytes(String text) {
        int len = text.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + text);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = Strings.hexCharToBin(text.charAt(i));
            int l = Strings.hexCharToBin(text.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + text);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    public static String hexStringToString(String text) {
        return new String(Strings.hexStringToBytes(text), StandardCharsets.UTF_8);
    }

    private static int hexCharToBin(char hex) {
        return switch (hex) {
            case '0' -> 0;
            case '1' -> 1;
            case '2' -> 2;
            case '3' -> 3;
            case '4' -> 4;
            case '5' -> 5;
            case '6' -> 6;
            case '7' -> 7;
            case '8' -> 8;
            case '9' -> 9;
            case 'A' -> 10;
            case 'B' -> 11;
            case 'C' -> 12;
            case 'D' -> 13;
            case 'E' -> 14;
            case 'F' -> 15;
            default -> -1;
        };
    }
}

